/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.search.map.ExtendableMap;
import aima.search.map.MapStepCostFunction;
import junit.framework.TestCase;

public class MapStepCostFunctionTest
extends TestCase {
    MapStepCostFunction mscf;

    @Override
    public void setUp() {
        ExtendableMap aMap = new ExtendableMap();
        aMap.addBidirectionalLink("A", "B", 5.0);
        aMap.addBidirectionalLink("A", "C", 6.0);
        aMap.addBidirectionalLink("B", "C", 4.0);
        aMap.addBidirectionalLink("C", "D", 7.0);
        aMap.addUnidirectionalLink("B", "E", 14.0);
        this.mscf = new MapStepCostFunction(aMap);
    }

    public void testCosts() {
        MapStepCostFunctionTest.assertEquals(new Double(5.0), this.mscf.calculateStepCost("A", "B", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(6.0), this.mscf.calculateStepCost("A", "C", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(4.0), this.mscf.calculateStepCost("B", "C", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(7.0), this.mscf.calculateStepCost("C", "D", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(14.0), this.mscf.calculateStepCost("B", "E", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(5.0), this.mscf.calculateStepCost("B", "A", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(6.0), this.mscf.calculateStepCost("C", "A", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(4.0), this.mscf.calculateStepCost("C", "B", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(7.0), this.mscf.calculateStepCost("D", "C", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(1.0), this.mscf.calculateStepCost("X", "Z", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(1.0), this.mscf.calculateStepCost("A", "Z", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(1.0), this.mscf.calculateStepCost("A", "D", "Go"));
        MapStepCostFunctionTest.assertEquals(new Double(1.0), this.mscf.calculateStepCost("A", "E", "Go"));
    }
}

