/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.DepthFirstSearch;
import java.util.List;
import junit.framework.TestCase;

public class DepthFirstSearchTest
extends TestCase {
    public void testDepthFirstSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthFirstSearch search = new DepthFirstSearch(new GraphSearch());
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        this.assertCorrectPlacement(actions2);
        DepthFirstSearchTest.assertEquals("113", agent.getInstrumentation().getProperty("nodesExpanded"));
    }

    public void testDepthFirstUnSuccessfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthFirstSearch search = new DepthFirstSearch(new GraphSearch());
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        DepthFirstSearchTest.assertEquals(0, actions2.size());
        DepthFirstSearchTest.assertEquals("6", agent.getInstrumentation().getProperty("nodesExpanded"));
    }

    private void assertCorrectPlacement(List actions2) {
        DepthFirstSearchTest.assertEquals(8, actions2.size());
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 0  7", actions2.get(0));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 1  3", actions2.get(1));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 2  0", actions2.get(2));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 3  2", actions2.get(3));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 4  5", actions2.get(4));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 5  1", actions2.get(5));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 6  6", actions2.get(6));
        DepthFirstSearchTest.assertEquals((Object)"placeQueenAt 7  4", actions2.get(7));
    }
}

