/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.HeuristicFunction;
import aima.search.framework.Search;
import aima.search.informed.AStarEvaluationFunction;
import aima.search.informed.RecursiveBestFirstSearch;
import aima.search.map.Map;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.map.Point2D;
import aima.search.map.SimplifiedRoadMapOfPartOfRomania;
import junit.framework.TestCase;

public class RecursiveBestFirstSearchTest
extends TestCase {
    StringBuffer envChanges;
    Map aMap;
    RecursiveBestFirstSearch recursiveBestFirstSearch;
    HeuristicFunction heuristicFunction;

    @Override
    public void setUp() {
        this.envChanges = new StringBuffer();
        this.aMap = new SimplifiedRoadMapOfPartOfRomania();
        this.recursiveBestFirstSearch = new RecursiveBestFirstSearch(new AStarEvaluationFunction());
        this.heuristicFunction = new HeuristicFunction(){

            @Override
            public double getHeuristicValue(Object state) {
                Point2D pt1 = RecursiveBestFirstSearchTest.this.aMap.getPosition((String)state);
                Point2D pt2 = RecursiveBestFirstSearchTest.this.aMap.getPosition("Bucharest");
                return pt1.distance(pt2);
            }
        };
    }

    public void testStartingAtGoal() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        MapAgent ma = new MapAgent(me, (Search)this.recursiveBestFirstSearch, new String[]{"Bucharest"});
        ma.setHeuristicFunction(this.heuristicFunction);
        me.addAgent(ma, "Bucharest");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                RecursiveBestFirstSearchTest.this.envChanges.append(command).append(":");
            }
        });
        me.stepUntilDone();
        RecursiveBestFirstSearchTest.assertEquals("CurrentLocation=In(Bucharest), Goal=In(Bucharest):NoOP:METRIC[pathCost]=0.0:METRIC[maxRecursiveDepth]=0:METRIC[nodesExpanded]=0:NoOP:", this.envChanges.toString());
    }

    public void testExampleFromBookFigure4_6Page103() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        MapAgent ma = new MapAgent(me, (Search)this.recursiveBestFirstSearch, new String[]{"Bucharest"});
        ma.setHeuristicFunction(this.heuristicFunction);
        me.addAgent(ma, "Arad");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                RecursiveBestFirstSearchTest.this.envChanges.append(command).append(":");
            }
        });
        me.stepUntilDone();
        RecursiveBestFirstSearchTest.assertEquals("CurrentLocation=In(Arad), Goal=In(Bucharest):Sibiu:RimnicuVilcea:Pitesti:Bucharest:METRIC[pathCost]=418.0:METRIC[maxRecursiveDepth]=4:METRIC[nodesExpanded]=6:NoOP:", this.envChanges.toString());
    }
}

