/*
 * Decompiled with CFR 0.152.
 */
package aima.util;

import java.util.Hashtable;
import java.util.Set;

public class FrequencyCounter<T> {
    private Hashtable<T, Integer> counter = new Hashtable();

    public Integer getCount(T key) {
        Integer value = this.counter.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public void incrementFor(T key) {
        Integer value = this.counter.get(key);
        if (value == null) {
            this.counter.put(key, 1);
        } else {
            this.counter.put(key, value + 1);
        }
    }

    public Double probabilityOf(T key) {
        Integer value = this.getCount(key);
        if (value == 0) {
            return 0.0;
        }
        Double total = 0.0;
        for (T k : this.counter.keySet()) {
            total = total + (double)this.getCount(k).intValue();
        }
        return (double)value.intValue() / total;
    }

    public String toString() {
        return this.counter.toString();
    }

    public Set<T> getStates() {
        return this.counter.keySet();
    }
}

