/*
 * Decompiled with CFR 0.152.
 */
package com.github.daytron.simpledialogfx.dialog;

import com.github.daytron.simpledialogfx.data.DialogResponse;
import com.github.daytron.simpledialogfx.data.DialogStyle;
import com.github.daytron.simpledialogfx.data.DialogText;
import com.github.daytron.simpledialogfx.data.HeaderColorStyle;
import com.github.daytron.simpledialogfx.dialog.DialogType;
import com.github.daytron.simpledialogfx.dialog.PreDefinedStyle;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class Dialog
extends Stage
implements Initializable {
    @FXML
    private VBox topBoxContainer;
    @FXML
    private StackPane headContainer;
    @FXML
    private StackPane bodyContainer;
    @FXML
    private Label headerLabel;
    @FXML
    private Label detailsLabel;
    @FXML
    private HBox okParent;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button yesButton;
    @FXML
    private Button noButton;
    @FXML
    private TextArea exceptionArea;
    @FXML
    private TextField inputTextField;
    @FXML
    private Button sendButton;
    private final String header;
    private final String details;
    private DialogResponse response;
    private Scene scene;
    private FXMLLoader fxmlLoader;
    private final DialogType dialogType;
    private final DialogStyle dialogStyle;
    private final Exception exception;
    private String textEntry;
    private HeaderColorStyle headerColorStyle;
    private boolean isLoadingError = false;

    public Dialog(DialogType dialogType, String header, String details) {
        this(dialogType, DialogStyle.NATIVE, "", header, details, null);
    }

    public Dialog(DialogType dialogType, HeaderColorStyle headerColorStyle, String header, String details) {
        this(dialogType, DialogStyle.NATIVE, "", header, headerColorStyle, details, null);
    }

    public Dialog(DialogType dialogType, HeaderColorStyle headerColorStyle, String title, String header, String details) {
        this(dialogType, DialogStyle.NATIVE, title, header, headerColorStyle, details, null);
    }

    public Dialog(DialogType dialogType, DialogStyle dialogStyle, String header, String details) {
        this(dialogType, dialogStyle, "", header, details, null);
    }

    public Dialog(DialogType dialogType, DialogStyle dialogStyle, String title, String header, String details) {
        this(dialogType, dialogStyle, title, header, details, null);
    }

    public Dialog(DialogType dialogType, String title, String header, String details) {
        this(dialogType, DialogStyle.NATIVE, title, header, details, null);
    }

    public Dialog(Exception exception) {
        this(DialogStyle.NATIVE, exception);
    }

    public Dialog(String title, Exception exception) {
        this(DialogStyle.NATIVE, title, exception);
    }

    public Dialog(DialogStyle dialogStyle, Exception exception) {
        this(dialogStyle, "", exception);
    }

    public Dialog(DialogStyle dialogStyle, String title, Exception exception) {
        this(DialogType.EXCEPTION, dialogStyle, title, DialogText.EXCEPTION_HEADER.getText(), exception.getClass().getName(), exception);
    }

    public Dialog(DialogType dialogType, DialogStyle dialogStyle, String title, String header, String details, Exception exception) {
        this(dialogType, dialogStyle, title, header, HeaderColorStyle.DEFAULT, details, exception);
    }

    public Dialog(DialogType dialogType, DialogStyle dialogStyle, String title, String header, HeaderColorStyle headerColorStyle, String details, Exception exception) {
        this.setTitle(title);
        this.headerColorStyle = headerColorStyle;
        this.dialogType = dialogType;
        this.exception = exception;
        this.dialogStyle = dialogStyle;
        if (dialogType == DialogType.EXCEPTION) {
            if (this.exception != null) {
                this.header = header;
                this.details = this.exception.getClass().getName();
            } else {
                this.header = DialogText.NO_EXCEPTION_HEADER.getText();
                this.details = DialogText.NO_EXCEPTION_DETAILS.getText();
            }
        } else {
            this.header = header;
            this.details = details;
        }
        this.textEntry = "";
        this.response = DialogResponse.NO_RESPONSE;
        try {
            this.fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(dialogType.getPath()));
            this.fxmlLoader.setController((Object)this);
            this.scene = new Scene((Parent)this.fxmlLoader.load());
            this.setScene(this.scene);
            this.centerOnScreen();
            if (dialogStyle == DialogStyle.UNDECORATED) {
                this.initStyle(StageStyle.UNDECORATED);
            }
            this.setResizable(false);
            this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Dialog.this.response = DialogResponse.CLOSE;
                }
            });
        }
        catch (Exception ex) {
            this.isLoadingError = true;
            Logger.getLogger(Dialog.class.getName()).log(Level.SEVERE, DialogText.CAUGHT_EXCEPTION_LOG_MSG.getText(), ex);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.addEventHandler(WindowEvent.ANY, (EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent window) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (Dialog.this.isLoadingError) {
                            Dialog.this.close();
                        }
                    }
                });
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                switch (Dialog.this.dialogType) {
                    case INFORMATION: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case CONFIRMATION: {
                        Dialog.this.yesButton.requestFocus();
                        break;
                    }
                    case CONFIRMATION_ALT1: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case CONFIRMATION_ALT2: {
                        Dialog.this.yesButton.requestFocus();
                        break;
                    }
                    case WARNING: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case ERROR: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case EXCEPTION: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case INPUT_TEXT: {
                        Dialog.this.inputTextField.requestFocus();
                        break;
                    }
                    case GENERIC_OK: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case GENERIC_OK_CANCEL: {
                        Dialog.this.okButton.requestFocus();
                        break;
                    }
                    case GENERIC_YES_NO: {
                        Dialog.this.yesButton.requestFocus();
                        break;
                    }
                    case GENERIC_YES_NO_CANCEL: {
                        Dialog.this.yesButton.requestFocus();
                    }
                }
            }
        });
        this.detailsLabel.setWrapText(true);
        this.headerLabel.setText(this.getHeader());
        this.detailsLabel.setText(this.getDetails());
        if (this.dialogType == DialogType.EXCEPTION) {
            this.exceptionArea.clear();
            if (this.exception != null) {
                this.exceptionArea.appendText(Arrays.toString(this.exception.getStackTrace()));
            } else {
                this.exceptionArea.appendText(DialogText.NO_EXCEPTION_TRACE.getText());
            }
            this.exceptionArea.setWrapText(true);
            this.exceptionArea.setEditable(false);
        }
        if (this.dialogStyle == DialogStyle.HEADLESS) {
            this.topBoxContainer.getChildren().remove((Object)this.headContainer);
            this.setHeadlessPadding();
        }
        this.setHeaderColorStyle(this.headerColorStyle);
    }

    private void setHeadlessPadding() {
        if (this.dialogType == DialogType.INPUT_TEXT) {
            this.bodyContainer.setStyle(PreDefinedStyle.INPUT_DIALOG_HEADLESS_PADDING.getStyle());
        } else if (this.dialogType == DialogType.EXCEPTION) {
            this.bodyContainer.setStyle(PreDefinedStyle.EXCEPTION_DIALOG_HEADLESS_PADDING.getStyle());
        } else {
            this.bodyContainer.setStyle(PreDefinedStyle.HEADLESS_PADDING.getStyle());
        }
    }

    public final void setHeaderColorStyle(HeaderColorStyle headerColorStyle) {
        this.headerColorStyle = headerColorStyle;
        if (!headerColorStyle.getColorStyle().isEmpty()) {
            this.getHeaderLabel().setStyle(headerColorStyle.getColorStyle());
        } else if (headerColorStyle == HeaderColorStyle.DEFAULT) {
            switch (this.dialogType) {
                case INFORMATION: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_INFO);
                    break;
                }
                case ERROR: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_ERROR);
                    break;
                }
                case WARNING: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_WARNING);
                    break;
                }
                case CONFIRMATION: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_CONFIRM);
                    break;
                }
                case CONFIRMATION_ALT1: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_CONFIRM);
                    break;
                }
                case CONFIRMATION_ALT2: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_CONFIRM);
                    break;
                }
                case EXCEPTION: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_EXCEPTION);
                    break;
                }
                case INPUT_TEXT: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GLOSS_INPUT);
                    break;
                }
                default: {
                    this.updateHeaderColorStyle(HeaderColorStyle.GENERIC);
                }
            }
        }
    }

    private void updateHeaderColorStyle(HeaderColorStyle headerColorStyle) {
        this.headerColorStyle = headerColorStyle;
        this.getHeaderLabel().setStyle(headerColorStyle.getColorStyle());
    }

    private void setResponse(DialogResponse response) {
        this.response = response;
    }

    public final DialogResponse getResponse() {
        return this.response;
    }

    public final String getDetails() {
        return this.details;
    }

    public final String getHeader() {
        return this.header;
    }

    public final HeaderColorStyle getHeaderColorStyle() {
        return this.headerColorStyle;
    }

    public final void setCustomHeaderColorStyle(String colorStyle) {
        this.headerColorStyle = HeaderColorStyle.CUSTOM;
        this.getHeaderLabel().setStyle(colorStyle);
    }

    public void setFontSize(int font_size) {
        this.setFontSize(font_size, font_size);
    }

    public void setFontSize(int header_font_size, int details_font_size) {
        this.headerLabel.setStyle("-fx-font-size:" + Integer.toString(header_font_size) + "px;");
        this.detailsLabel.setStyle("-fx-font-size:" + Integer.toString(details_font_size) + "px;");
    }

    public void setHeaderFontSize(int font_size) {
        this.headerLabel.setStyle("-fx-font-size:" + Integer.toString(font_size) + "px;");
    }

    public void setDetailsFontSize(int font_size) {
        this.detailsLabel.setStyle("-fx-font-size:" + Integer.toString(font_size) + "px;");
    }

    public void setFontFamily(String font_family) {
        this.setFontFamily(font_family, font_family);
    }

    public void setFontFamily(String header_font_family, String details_font_family) {
        this.headerLabel.setStyle("-fx-font-family: \"" + header_font_family + "\";");
        this.detailsLabel.setStyle("-fx-font-family: \"" + details_font_family + "\";");
    }

    public void setHeaderFontFamily(String font_family) {
        this.headerLabel.setStyle("-fx-font-family: \"" + font_family + "\";");
    }

    public void setDetailsFontFamily(String font_family) {
        this.detailsLabel.setStyle("-fx-font-family: \"" + font_family + "\";");
    }

    public void setFont(String font_family, int font_size) {
        this.setFont(font_family, font_size, font_family, font_size);
    }

    public void setFont(String header_font_family, int header_font_size, String details_font_family, int details_font_size) {
        this.headerLabel.setStyle("-fx-font-family: \"" + header_font_family + "\";-fx-font-size:" + Integer.toString(header_font_size) + "px;");
        this.detailsLabel.setStyle("-fx-font-family: \"" + details_font_family + "\";-fx-font-size:" + Integer.toString(details_font_size) + "px;");
    }

    public void setHeaderFont(String font_family, int font_size) {
        this.headerLabel.setStyle("-fx-font-family: \"" + font_family + "\";-fx-font-size:" + Integer.toString(font_size) + "px;");
    }

    public void setDetailsFont(String font_family, int font_size) {
        this.detailsLabel.setStyle("-fx-font-family: \"" + font_family + "\";-fx-font-size:" + Integer.toString(font_size) + "px;");
    }

    public final Label getHeaderLabel() {
        return this.headerLabel;
    }

    public final Label getDetailsLabel() {
        return this.detailsLabel;
    }

    public final TextArea getExceptionArea() {
        return this.exceptionArea;
    }

    public final Exception getException() {
        return this.exception;
    }

    public final String getTextEntry() {
        return this.textEntry;
    }

    public final TextField getTextField() {
        return this.inputTextField;
    }

    @FXML
    private void yes_btn_on_click(ActionEvent event) {
        this.setResponse(DialogResponse.YES);
        this.close();
    }

    @FXML
    private void no_btn_on_click(ActionEvent event) {
        this.setResponse(DialogResponse.NO);
        this.close();
    }

    @FXML
    private void ok_btn_on_click(ActionEvent event) {
        this.setResponse(DialogResponse.OK);
        this.close();
    }

    @FXML
    private void cancel_btn_on_click(ActionEvent event) {
        this.setResponse(DialogResponse.CANCEL);
        this.close();
    }

    @FXML
    private void send_btn_on_click(ActionEvent event) {
        if (this.dialogType == DialogType.INPUT_TEXT) {
            this.textEntry = this.inputTextField.getText();
        }
        this.setResponse(DialogResponse.SEND);
        this.close();
    }
}

