/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXChip;
import com.jfoenix.controls.JFXChipView;
import com.jfoenix.controls.JFXDefaultChip;
import com.jfoenix.controls.events.JFXAutoCompleteEvent;
import com.jfoenix.skins.JFXAutoCompletePopupSkin;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$1;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$2;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$3;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$4;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$5;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$6;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$7;
import com.jfoenix.skins.JFXChipViewSkin$$Lambda$8;
import java.util.List;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class JFXChipViewSkin<T>
extends SkinBase<JFXChipView<T>> {
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private CustomFlowPane root;
    private JFXChipView control;
    private TextArea inputField;
    private ChipsAutoComplete<T> autoCompletePopup;
    private boolean moveToNewLine = false;
    private boolean editorOnNewLine = true;
    private double availableWidth;
    private double requiredWidth;
    private final ListChangeListener<T> chipsChangeListeners = JFXChipViewSkin$$Lambda$1.lambdaFactory$(this);

    public JFXChipViewSkin(JFXChipView<T> control) {
        super(control);
        this.control = control;
        this.root = new CustomFlowPane();
        this.root.getStyleClass().add((Object)"chips-pane");
        this.setupEditor();
        this.getChildren().add((Object)this.root);
        this.autoCompletePopup = (ChipsAutoComplete)((JFXChipView)this.getSkinnable()).getAutoCompletePopup();
        this.autoCompletePopup.setSelectionHandler(JFXChipViewSkin$$Lambda$2.lambdaFactory$(this));
        this.autoCompletePopup.setShift(this.root.getVgap() * 2.0);
        this.root.vgapProperty().addListener(JFXChipViewSkin$$Lambda$3.lambdaFactory$(this));
        for (Object item : control.getChips()) {
            this.createChip(item);
        }
        control.getChips().addListener((ListChangeListener)new WeakListChangeListener(this.chipsChangeListeners));
    }

    private void setupEditor() {
        this.inputField = new TextArea();
        this.inputField.setManaged(false);
        this.inputField.getStyleClass().add((Object)"editor");
        StringConverter sc = this.control.getConverter();
        if (this.inputField instanceof TextInputControl) {
            TextArea editor = this.inputField;
            editor.addEventFilter(KeyEvent.KEY_RELEASED, JFXChipViewSkin$$Lambda$4.lambdaFactory$(this));
            if (editor instanceof TextArea) {
                editor.setWrapText(true);
                editor.textProperty().addListener(JFXChipViewSkin$$Lambda$5.lambdaFactory$(this, (TextInputControl)editor));
            }
            editor.addEventFilter(KeyEvent.KEY_PRESSED, JFXChipViewSkin$$Lambda$6.lambdaFactory$(this, (TextInputControl)editor, sc));
            editor.textProperty().addListener(JFXChipViewSkin$$Lambda$7.lambdaFactory$(this, (TextInputControl)editor));
        }
        this.root.getChildren().add((Object)this.inputField);
    }

    private void createChip(T item) {
        JFXChip chip = ((JFXChipView)this.getSkinnable()).getChipFactory() != null ? ((JFXChipView)this.getSkinnable()).getChipFactory().apply((JFXChipView<Control>)this.getSkinnable(), (Control)item) : new JFXDefaultChip<T>((JFXChipView)this.getSkinnable(), item);
        int size = this.root.getChildren().size();
        this.root.getChildren().add(size - 1, chip);
    }

    private double computeTextContentWidth(TextInputControl editor) {
        Text text = new Text(editor.getText());
        text.setFont(editor.getFont());
        text.applyCss();
        return text.getLayoutBounds().getWidth();
    }

    static /* synthetic */ void lambda$setupEditor$7(JFXChipViewSkin this_, TextInputControl editor, Observable observable) {
        this_.autoCompletePopup.filter(JFXChipViewSkin$$Lambda$8.lambdaFactory$(this_));
        if (this_.autoCompletePopup.getFilteredSuggestions().isEmpty()) {
            this_.autoCompletePopup.hide();
        } else {
            this_.autoCompletePopup.show((Node)editor);
        }
    }

    static /* synthetic */ boolean lambda$null$6(JFXChipViewSkin this_, Object item) {
        return ((JFXChipView)this_.getSkinnable()).getPredicate().test(item, this_.inputField.getText());
    }

    static /* synthetic */ void lambda$setupEditor$5(JFXChipViewSkin this_, TextInputControl editor, StringConverter sc, KeyEvent event) {
        ObservableList chips;
        int size;
        if (event.getCode() == KeyCode.ENTER) {
            if (!editor.getText().trim().isEmpty()) {
                try {
                    ((JFXChipView)this_.getSkinnable()).getChips().add(sc.fromString(editor.getText()));
                    editor.clear();
                    this_.autoCompletePopup.hide();
                }
                catch (Exception ex) {
                    ((JFXChipView)this_.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
                }
            }
            event.consume();
        }
        if (event.getCode() == KeyCode.BACK_SPACE && (size = (chips = ((JFXChipView)this_.getSkinnable()).getChips()).size()) > 0 && editor.getText().isEmpty()) {
            chips.remove(size - 1);
            if (this_.autoCompletePopup.isShowing()) {
                this_.autoCompletePopup.hide();
            }
        }
    }

    static /* synthetic */ void lambda$setupEditor$4(JFXChipViewSkin this_, TextInputControl editor, Observable observable) {
        this_.requiredWidth = editor.snappedLeftInset() + this_.computeTextContentWidth(editor) + editor.snappedRightInset() + 13.0;
        if (this_.availableWidth < this_.requiredWidth && !this_.editorOnNewLine) {
            this_.moveToNewLine = true;
            this_.root.updateEditorPosition();
            this_.root.requestLayout();
        } else if (this_.availableWidth > this_.requiredWidth && this_.editorOnNewLine) {
            this_.moveToNewLine = false;
            this_.root.updateEditorPosition();
            this_.root.requestLayout();
        }
    }

    static /* synthetic */ void lambda$setupEditor$3(JFXChipViewSkin this_, KeyEvent event) {
        if (event.getCode() != KeyCode.ENTER) {
            ((JFXChipView)this_.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
        }
    }

    static /* synthetic */ void lambda$new$2(JFXChipViewSkin this_, Observable observable) {
        this_.autoCompletePopup.setShift(this_.root.getVgap() * 2.0);
    }

    static /* synthetic */ void lambda$new$1(JFXChipViewSkin this_, JFXAutoCompleteEvent event) {
        ((JFXChipView)this_.getSkinnable()).getChips().add(event.getObject());
        this_.inputField.clear();
    }

    static /* synthetic */ void lambda$new$0(JFXChipViewSkin this_, ListChangeListener.Change change) {
        while (change.next()) {
            block1: for (Object item : change.getRemoved()) {
                for (int i = this_.root.getChildren().size() - 2; i >= 0; --i) {
                    Node child = (Node)this_.root.getChildren().get(i);
                    if (!(child instanceof JFXChip) || ((JFXChip)child).getItem() != item) continue;
                    this_.root.getChildren().remove(i);
                    continue block1;
                }
            }
            for (Object item : change.getAddedSubList()) {
                this_.createChip(item);
            }
        }
    }

    public static class ChipsAutoComplete<T>
    extends JFXAutoCompletePopup<T> {
        private double shift = 0.0;
        private Text text;

        public ChipsAutoComplete() {
            this.getStyleClass().add((Object)"jfx-chips-popup");
        }

        void setShift(double shift) {
            this.shift = shift;
        }

        @Override
        public void show(Node node) {
            if (this.text == null) {
                this.text = (Text)node.lookup(".text");
            }
            node = this.text;
            if (!this.isShowing()) {
                if (node.getScene() == null || node.getScene().getWindow() == null) {
                    throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
                }
                Window parent = node.getScene().getWindow();
                this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getLayoutBounds().getHeight() + this.shift);
                ((JFXAutoCompletePopupSkin)this.getSkin()).animate();
            } else {
                Window parent = node.getScene().getWindow();
                this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getLayoutBounds().getHeight() + this.shift);
            }
        }
    }

    private class CustomFlowPane
    extends FlowPane {
        double initOffset = 8.0;
        double childHeight = 0.0;

        private CustomFlowPane() {
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.updateEditorPosition();
        }

        private VPos getRowValignmentInternal() {
            VPos localPos = this.getRowValignment();
            return localPos == null ? VPos.CENTER : localPos;
        }

        private HPos getColumnHalignmentInternal() {
            HPos localPos = this.getColumnHalignment();
            return localPos == null ? HPos.LEFT : localPos;
        }

        public void updateEditorPosition() {
            Insets insets = this.getInsets();
            double width = this.getWidth();
            double height = this.getHeight();
            double top = insets.getTop();
            double left = insets.getLeft();
            double bottom = insets.getBottom();
            double right = insets.getRight();
            double insideWidth = width - left - right;
            double insideHeight = height - top - bottom;
            double newLineEditorX = right + this.initOffset;
            List managedChildren = this.getManagedChildren();
            int mangedChildrenSize = managedChildren.size();
            if (mangedChildrenSize > 0) {
                Region lastChild = (Region)managedChildren.get(mangedChildrenSize - 1);
                this.childHeight = lastChild.getHeight();
                double contentHeight = lastChild.getHeight() + lastChild.getLayoutY();
                JFXChipViewSkin.this.availableWidth = insideWidth - lastChild.getBoundsInParent().getMaxX();
                double minWidth = JFXChipViewSkin.this.inputField.getMinWidth();
                minWidth = minWidth < 0.0 ? 100.0 : minWidth;
                minWidth = Math.max(minWidth, JFXChipViewSkin.this.requiredWidth);
                if (JFXChipViewSkin.this.availableWidth > JFXChipViewSkin.this.requiredWidth) {
                    JFXChipViewSkin.this.moveToNewLine = false;
                }
                if (JFXChipViewSkin.this.availableWidth < minWidth || JFXChipViewSkin.this.moveToNewLine) {
                    this.layoutInArea((Node)JFXChipViewSkin.this.inputField, newLineEditorX, contentHeight + JFXChipViewSkin.this.root.getVgap(), insideWidth - this.initOffset, insideHeight - lastChild.getHeight() - lastChild.getLayoutY(), 0.0, this.getColumnHalignmentInternal(), VPos.TOP);
                    JFXChipViewSkin.this.editorOnNewLine = true;
                } else {
                    double controlInsets = 0.0;
                    if (JFXChipViewSkin.this.inputField instanceof TextArea) {
                        controlInsets = JFXChipViewSkin.this.inputField.snappedTopInset();
                    }
                    this.layoutInArea((Node)JFXChipViewSkin.this.inputField, lastChild.getBoundsInParent().getMaxX() + JFXChipViewSkin.this.root.getHgap(), lastChild.getLayoutY() + controlInsets, JFXChipViewSkin.this.availableWidth - JFXChipViewSkin.this.root.getHgap(), lastChild.getHeight(), 0.0, this.getColumnHalignmentInternal(), this.getRowValignmentInternal());
                    JFXChipViewSkin.this.editorOnNewLine = false;
                }
            } else {
                this.layoutInArea((Node)JFXChipViewSkin.this.inputField, newLineEditorX, top, insideWidth - this.initOffset, height, 0.0, this.getColumnHalignmentInternal(), VPos.TOP);
                JFXChipViewSkin.this.editorOnNewLine = true;
            }
        }
    }
}

