/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.behavior.JFXDatePickerBehavior;
import com.jfoenix.skins.JFXDatePickerContent;
import com.jfoenix.skins.JFXDatePickerSkin$$Lambda$1;
import com.jfoenix.skins.JFXDatePickerSkin$$Lambda$2;
import com.jfoenix.svg.SVGGlyph;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.YearMonth;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class JFXDatePickerSkin
extends ComboBoxPopupControl<LocalDate> {
    private JFXDatePicker jfxDatePicker;
    private TextField displayNode;
    private JFXDatePickerContent content;
    private JFXDialog dialog;

    public JFXDatePickerSkin(JFXDatePicker datePicker) {
        super((ComboBoxBase)datePicker, (ComboBoxBaseBehavior)new JFXDatePickerBehavior(datePicker));
        this.jfxDatePicker = datePicker;
        try {
            Field helper = datePicker.focusedProperty().getClass().getSuperclass().getDeclaredField("helper");
            helper.setAccessible(true);
            ExpressionHelper value = (ExpressionHelper)helper.get(datePicker.focusedProperty());
            Field changeListenersField = value.getClass().getDeclaredField("changeListeners");
            changeListenersField.setAccessible(true);
            ChangeListener[] changeListeners = (ChangeListener[])changeListenersField.get(value);
            for (int i = changeListeners.length - 1; i > 0; --i) {
                if (changeListeners[i] == null || !changeListeners[i].getClass().getName().contains("ComboBoxPopupControl")) continue;
                datePicker.focusedProperty().removeListener(changeListeners[i]);
                break;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        datePicker.focusedProperty().addListener(JFXDatePickerSkin$$Lambda$1.lambdaFactory$(this));
        this.arrow = new SVGGlyph(0, "calendar", "M320 384h128v128h-128zM512 384h128v128h-128zM704 384h128v128h-128zM128 768h128v128h-128zM320 768h128v128h-128zM512 768h128v128h-128zM320 576h128v128h-128zM512 576h128v128h-128zM704 576h128v128h-128zM128 576h128v128h-128zM832 0v64h-128v-64h-448v64h-128v-64h-128v1024h960v-1024h-128zM896 960h-832v-704h832v704z", null);
        ((SVGGlyph)this.arrow).setFill(this.jfxDatePicker.getDefaultColor());
        ((SVGGlyph)this.arrow).setSize(20.0, 20.0);
        this.arrowButton.getChildren().setAll((Object[])new Node[]{this.arrow});
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxDatePicker.getDefaultColor());
        this.registerChangeListener((ObservableValue)datePicker.converterProperty(), "CONVERTER");
        this.registerChangeListener((ObservableValue)datePicker.dayCellFactoryProperty(), "DAY_CELL_FACTORY");
        this.registerChangeListener((ObservableValue)datePicker.showWeekNumbersProperty(), "SHOW_WEEK_NUMBERS");
        this.registerChangeListener((ObservableValue)datePicker.valueProperty(), "VALUE");
    }

    protected Node getPopupContent() {
        if (this.content == null) {
            this.content = new JFXDatePickerContent(this.jfxDatePicker);
        }
        return this.content;
    }

    public void show() {
        if (!((JFXDatePicker)this.getSkinnable()).isOverLay()) {
            super.show();
        }
        if (this.content != null) {
            this.content.init();
            this.content.clearFocus();
        }
        if (((JFXDatePicker)this.getSkinnable()).isOverLay() && this.dialog == null) {
            StackPane dialogParent = this.jfxDatePicker.getDialogParent();
            if (dialogParent == null) {
                dialogParent = (StackPane)((ComboBoxBase)this.getSkinnable()).getScene().getRoot();
            }
            this.dialog = new JFXDialog(dialogParent, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.arrowButton.setOnMouseClicked(JFXDatePickerSkin$$Lambda$2.lambdaFactory$(this));
        }
    }

    protected void handleControlPropertyChanged(String p) {
        if ("DAY_CELL_FACTORY".equals(p)) {
            this.updateDisplayNode();
            this.content = null;
            this.popup = null;
        } else if ("CONVERTER".equals(p)) {
            this.updateDisplayNode();
        } else if ("EDITOR".equals(p)) {
            this.getEditableInputNode();
        } else if ("SHOWING".equals(p)) {
            if (this.jfxDatePicker.isShowing()) {
                if (this.content != null) {
                    LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                    this.content.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
                    this.content.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        } else if ("SHOW_WEEK_NUMBERS".equals(p)) {
            if (this.content != null) {
                this.content.updateContentGrid();
                this.content.updateWeekNumberDateCells();
            }
        } else if ("VALUE".equals(p)) {
            this.updateDisplayNode();
            if (this.content != null) {
                LocalDate date = (LocalDate)this.jfxDatePicker.getValue();
                this.content.displayedYearMonthProperty().set((Object)(date != null ? YearMonth.from(date) : YearMonth.now()));
                this.content.updateValues();
            }
            this.jfxDatePicker.fireEvent((Event)new ActionEvent());
        } else {
            super.handleControlPropertyChanged(p);
        }
    }

    protected TextField getEditor() {
        return ((DatePicker)this.getSkinnable()).getEditor();
    }

    protected StringConverter<LocalDate> getConverter() {
        return ((DatePicker)this.getSkinnable()).getConverter();
    }

    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.getEditableInputNode();
            this.displayNode.getStyleClass().add((Object)"date-picker-display-node");
            this.updateDisplayNode();
        }
        this.displayNode.setEditable(this.jfxDatePicker.isEditable());
        return this.displayNode;
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && this.jfxDatePicker.isShowing()) {
            this.jfxDatePicker.hide();
        }
    }

    static /* synthetic */ void lambda$show$1(JFXDatePickerSkin this_, MouseEvent click) {
        if (((JFXDatePicker)this_.getSkinnable()).isOverLay()) {
            StackPane parent = this_.jfxDatePicker.getDialogParent();
            if (parent == null) {
                parent = (StackPane)((ComboBoxBase)this_.getSkinnable()).getScene().getRoot();
            }
            this_.dialog.show(parent);
        }
    }

    static /* synthetic */ void lambda$new$0(JFXDatePickerSkin this_, ObservableValue obj, Boolean oldVal, Boolean newVal) {
        if (this_.getEditor() != null && !newVal.booleanValue()) {
            this_.setTextFromTextFieldIntoComboBoxValue();
        }
    }
}

