/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$1;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$10;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$2;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$3;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$4;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$5;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$6;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$7;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$8;
import com.jfoenix.skins.JFXToggleButtonSkin$$Lambda$9;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import com.sun.javafx.scene.control.skin.ToggleButtonSkin;
import javafx.animation.Interpolator;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.util.Duration;

public class JFXToggleButtonSkin
extends ToggleButtonSkin {
    private Runnable releaseManualRippler = null;
    private JFXAnimationTimer timer;
    private final Circle circle;
    private final Line line;

    public JFXToggleButtonSkin(JFXToggleButton toggleButton) {
        super((ToggleButton)toggleButton);
        double circleRadius = toggleButton.getSize();
        this.line = new Line();
        this.line.setStartX(0.0);
        this.line.setStartY(0.0);
        this.line.setEndX(circleRadius * 2.0 + 2.0);
        this.line.setEndY(0.0);
        this.line.setStrokeWidth(circleRadius * 1.5);
        this.line.setStrokeLineCap(StrokeLineCap.ROUND);
        this.line.setSmooth(true);
        this.circle = new Circle();
        this.circle.setCenterX(-circleRadius);
        this.circle.setCenterY(0.0);
        this.circle.setRadius(circleRadius);
        this.circle.setSmooth(true);
        JFXDepthManager.setDepth((Node)this.circle, 1);
        StackPane circlePane = new StackPane();
        circlePane.getChildren().add((Object)this.circle);
        circlePane.setPadding(new Insets(circleRadius * 1.5));
        JFXRippler rippler = new JFXRippler((Node)circlePane, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        rippler.setTranslateX(this.computeTranslation(circleRadius, this.line));
        StackPane main = new StackPane();
        main.getChildren().setAll((Object[])new Node[]{this.line, rippler});
        main.setCursor(Cursor.HAND);
        ((ToggleButton)this.getSkinnable()).armedProperty().addListener(JFXToggleButtonSkin$$Lambda$1.lambdaFactory$(this, rippler));
        toggleButton.focusedProperty().addListener(JFXToggleButtonSkin$$Lambda$2.lambdaFactory$(this, toggleButton, rippler));
        toggleButton.pressedProperty().addListener(JFXToggleButtonSkin$$Lambda$3.lambdaFactory$(rippler));
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener(JFXToggleButtonSkin$$Lambda$4.lambdaFactory$(this, toggleButton, rippler, circleRadius));
        ((ToggleButton)this.getSkinnable()).setGraphic((Node)main);
        this.timer = new JFXAnimationTimer(new JFXKeyFrame(Duration.millis((double)100.0), JFXKeyValue.builder().setTarget((WritableValue<?>)rippler.translateXProperty()).setEndValueSupplier(JFXToggleButtonSkin$$Lambda$5.lambdaFactory$(this, circleRadius)).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(JFXToggleButtonSkin$$Lambda$6.lambdaFactory$(this)).build(), JFXKeyValue.builder().setTarget((WritableValue<?>)this.line.strokeProperty()).setEndValueSupplier(JFXToggleButtonSkin$$Lambda$7.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(JFXToggleButtonSkin$$Lambda$8.lambdaFactory$(this)).build(), JFXKeyValue.builder().setTarget((WritableValue<?>)this.circle.fillProperty()).setEndValueSupplier(JFXToggleButtonSkin$$Lambda$9.lambdaFactory$(this)).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(JFXToggleButtonSkin$$Lambda$10.lambdaFactory$(this)).build()));
        this.timer.setCacheNodes(new Node[]{this.circle, this.line});
        this.registerChangeListener((ObservableValue)toggleButton.toggleColorProperty(), "TOGGLE_COLOR");
        this.registerChangeListener((ObservableValue)toggleButton.unToggleColorProperty(), "UNTOGGLE_COLOR");
        this.registerChangeListener((ObservableValue)toggleButton.toggleLineColorProperty(), "TOGGLE_LINE_COLOR");
        this.registerChangeListener((ObservableValue)toggleButton.unToggleColorProperty(), "UNTOGGLE_LINE_COLOR");
    }

    protected void handleControlPropertyChanged(String p) {
        if ("TOGGLE_COLOR".equals(p)) {
            if (((ToggleButton)this.getSkinnable()).isSelected()) {
                this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getToggleColor());
            }
        } else if ("UNTOGGLE_COLOR".equals(p)) {
            if (!((ToggleButton)this.getSkinnable()).isSelected()) {
                this.circle.setFill(((JFXToggleButton)this.getSkinnable()).getUnToggleColor());
            }
        } else if ("TOGGLE_LINE_COLOR".equals(p)) {
            if (((ToggleButton)this.getSkinnable()).isSelected()) {
                this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getToggleLineColor());
            }
        } else if ("UNTOGGLE_LINE_COLOR".equals(p)) {
            if (!((ToggleButton)this.getSkinnable()).isSelected()) {
                this.line.setStroke(((JFXToggleButton)this.getSkinnable()).getUnToggleLineColor());
            }
        } else {
            super.handleControlPropertyChanged(p);
        }
    }

    private double computeTranslation(double circleRadius, Line line) {
        return (double)(((ToggleButton)this.getSkinnable()).isSelected() ? 1 : -1) * (line.getLayoutBounds().getWidth() / 2.0 - circleRadius + 2.0);
    }

    public void dispose() {
        super.dispose();
        this.timer.dispose();
        this.timer = null;
    }

    static /* synthetic */ Boolean lambda$new$9(JFXToggleButtonSkin this_) {
        return ((JFXToggleButton)this_.getSkinnable()).isDisableAnimation() == false;
    }

    static /* synthetic */ Object lambda$new$8(JFXToggleButtonSkin this_) {
        return ((ToggleButton)this_.getSkinnable()).isSelected() ? ((JFXToggleButton)this_.getSkinnable()).getToggleColor() : ((JFXToggleButton)this_.getSkinnable()).getUnToggleColor();
    }

    static /* synthetic */ Boolean lambda$new$7(JFXToggleButtonSkin this_) {
        return ((JFXToggleButton)this_.getSkinnable()).isDisableAnimation() == false;
    }

    static /* synthetic */ Object lambda$new$6(JFXToggleButtonSkin this_) {
        return ((ToggleButton)this_.getSkinnable()).isSelected() ? ((JFXToggleButton)this_.getSkinnable()).getToggleLineColor() : ((JFXToggleButton)this_.getSkinnable()).getUnToggleLineColor();
    }

    static /* synthetic */ Boolean lambda$new$5(JFXToggleButtonSkin this_) {
        return ((JFXToggleButton)this_.getSkinnable()).isDisableAnimation() == false;
    }

    static /* synthetic */ Object lambda$new$4(JFXToggleButtonSkin this_, double circleRadius) {
        return this_.computeTranslation(circleRadius, this_.line);
    }

    static /* synthetic */ void lambda$new$3(JFXToggleButtonSkin this_, JFXToggleButton toggleButton, JFXRippler rippler, double circleRadius, Observable observable) {
        if (!toggleButton.isDisableAnimation().booleanValue()) {
            this_.timer.reverseAndContinue();
        } else {
            rippler.setTranslateX(this_.computeTranslation(circleRadius, this_.line));
        }
    }

    static /* synthetic */ void lambda$new$2(JFXRippler rippler, Observable observable) {
        rippler.setOverlayVisible(false);
    }

    static /* synthetic */ void lambda$new$1(JFXToggleButtonSkin this_, JFXToggleButton toggleButton, JFXRippler rippler, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (!toggleButton.isDisableVisualFocus().booleanValue()) {
            if (newVal.booleanValue()) {
                if (!((ToggleButton)this_.getSkinnable()).isPressed()) {
                    rippler.setOverlayVisible(true);
                }
            } else {
                rippler.setOverlayVisible(false);
            }
        }
    }

    static /* synthetic */ void lambda$new$0(JFXToggleButtonSkin this_, JFXRippler rippler, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            this_.releaseManualRippler = rippler.createManualRipple();
        } else if (this_.releaseManualRippler != null) {
            this_.releaseManualRippler.run();
        }
    }
}

