/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.centerdevice.javafxsvg;

import java.lang.reflect.Method;
import javafx.stage.Screen;

public class ScreenHelper {
    private static ScreenAccessor accessor = null;

    public static ScreenAccessor getScreenAccessor() {
        if (accessor == null) {
            accessor = new ScreenAccessor();
        }
        return accessor;
    }

    public static class ScreenAccessor {
        private static Method getRenderScale = null;

        private Method getScaleMethod() throws NoSuchMethodException {
            if (getRenderScale == null) {
                getRenderScale = this.lookupScaleMethod();
            }
            return getRenderScale;
        }

        private Method lookupScaleMethod() throws NoSuchMethodException {
            Method scaleMethod;
            try {
                scaleMethod = Screen.class.getDeclaredMethod("getScale", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                scaleMethod = Screen.class.getDeclaredMethod("getRenderScale", new Class[0]);
            }
            scaleMethod.setAccessible(true);
            return scaleMethod;
        }

        public float getRenderScale(Screen screen) {
            try {
                Method m = this.getScaleMethod();
                return ((Float)m.invoke((Object)screen, new Object[0])).floatValue();
            }
            catch (ReflectiveOperationException e) {
                return 1.0f;
            }
        }
    }
}

