/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXGraph;
import fxgraph.FXNode;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.TimelineBuilder;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;

public class FXGraphZoomHandler {
    private FXGraph graph;
    double currentZoomLevel;
    double targetZoomLevel;
    private Timeline zoomTimeLine;

    public FXGraphZoomHandler(FXGraph aGraph) {
        this.graph = aGraph;
        this.currentZoomLevel = 1.0;
        this.targetZoomLevel = 1.0;
        Duration theDuration = Duration.millis((double)40.0);
        KeyFrame theOneFrame = new KeyFrame(theDuration, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXGraphZoomHandler.this.updateNodePositionsAndScale();
            }
        }, new KeyValue[0]);
        this.zoomTimeLine = ((TimelineBuilder)TimelineBuilder.create().cycleCount(-1)).keyFrames(new KeyFrame[]{theOneFrame}).build();
        this.zoomTimeLine.play();
    }

    public void updateNodePositionsAndScale() {
        boolean evolvePosition = false;
        if (this.currentZoomLevel > this.targetZoomLevel) {
            this.currentZoomLevel -= (this.currentZoomLevel - this.targetZoomLevel) * 0.06;
            evolvePosition = true;
        }
        if (this.currentZoomLevel < this.targetZoomLevel) {
            this.currentZoomLevel += (this.targetZoomLevel - this.currentZoomLevel) * 0.06;
            evolvePosition = true;
        }
        if (evolvePosition) {
            for (FXNode theNode : this.graph.model.getNodes()) {
                theNode.setZoomLevel(this.currentZoomLevel);
            }
            this.graph.updateSelectionInScene();
        }
        if (Math.abs(this.currentZoomLevel - this.targetZoomLevel) < 0.01) {
            this.currentZoomLevel = this.targetZoomLevel;
        }
    }

    public void zoomOneStepIn() {
        this.targetZoomLevel -= 0.05;
        if (this.targetZoomLevel < 0.05) {
            this.targetZoomLevel = 0.05;
        }
        this.updateNodePositionsAndScale();
    }

    public void zoomOneStepOut() {
        this.targetZoomLevel += 0.05;
        this.updateNodePositionsAndScale();
    }

    public void zoomIn(int step) {
        for (int i = 0; i < step; ++i) {
            this.zoomOneStepIn();
        }
    }

    public void zoomOut(int step) {
        for (int i = 0; i < step; ++i) {
            this.zoomOneStepOut();
        }
    }

    public double getCurrentZoomLevel() {
        return this.currentZoomLevel;
    }

    public void setCurrentZoomLevel(double currentZoomLevel) {
        this.currentZoomLevel = currentZoomLevel;
    }
}

