/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.bucket;

import java.util.ArrayList;
import java.util.List;

public class TreeNode<T> {
    private T data = null;
    private List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
    private String labelF;
    private double pathCost;
    private String expansionOrder;
    private TreeNode<T> parent = null;

    public TreeNode(T data, String labelF, double pathCost, String expansionOrder) {
        this.data = data;
        this.labelF = labelF;
        this.pathCost = pathCost;
        this.expansionOrder = expansionOrder;
    }

    public TreeNode<T> addChild(TreeNode<T> child) {
        super.setParent(this);
        this.children.add(child);
        return child;
    }

    public void addChildren(List<TreeNode<T>> children) {
        children.forEach(each -> each.setParent(this));
        this.children.addAll(children);
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public String getLabelF() {
        return this.labelF;
    }

    public void setLabelF(String labelF) {
        this.labelF = labelF;
    }

    public double getPathCost() {
        return this.pathCost;
    }

    public void setPathCost(double pathCost) {
        this.pathCost = pathCost;
    }

    public String getExpansionOrder() {
        return this.expansionOrder;
    }

    public void setExpansionOrder(String expansionOrder) {
        this.expansionOrder = expansionOrder;
    }

    public int countLeaves(TreeNode<T> root) {
        int leaves = 0;
        if (root == null) {
            return 0;
        }
        if (root.getChildren().size() == 0) {
            return 1;
        }
        for (int i = 0; i < root.getChildren().size(); ++i) {
            leaves += this.countLeaves(root.getChildren().get(i));
        }
        return leaves;
    }

    public int getHeight(TreeNode<T> root) {
        int max = 0;
        for (TreeNode<T> childNode : root.getChildren()) {
            int height = this.getHeight(childNode);
            if (height <= max) continue;
            max = height;
        }
        return max + 1;
    }

    public String toString() {
        return "TreeNode{, labelF='" + this.labelF + '\'' + ", expansionOrder=" + this.expansionOrder + ", parent=" + this.parent + '}' + '\n';
    }
}

