/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.Quantifiers;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.FOLVisitor;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;

class RemoveQuantifiers
implements FOLVisitor {
    private FOLParser parser = null;
    private SubstVisitor substVisitor = null;

    public RemoveQuantifiers(FOLParser parser) {
        this.parser = parser;
        this.substVisitor = new SubstVisitor();
    }

    @Override
    public Object visitPredicate(Predicate p, Object arg) {
        return p;
    }

    @Override
    public Object visitTermEquality(TermEquality equality, Object arg) {
        return equality;
    }

    @Override
    public Object visitVariable(Variable variable, Object arg) {
        return variable;
    }

    @Override
    public Object visitConstant(Constant constant, Object arg) {
        return constant;
    }

    @Override
    public Object visitFunction(Function function, Object arg) {
        return function;
    }

    @Override
    public Object visitNotSentence(NotSentence sentence, Object arg) {
        return new NotSentence((Sentence)sentence.getNegated().accept(this, arg));
    }

    @Override
    public Object visitConnectedSentence(ConnectedSentence sentence, Object arg) {
        return new ConnectedSentence(sentence.getConnector(), (Sentence)sentence.getFirst().accept(this, arg), (Sentence)sentence.getSecond().accept(this, arg));
    }

    @Override
    public Object visitQuantifiedSentence(QuantifiedSentence sentence, Object arg) {
        Sentence quantified = sentence.getQuantified();
        Set universalScope = (Set)arg;
        if (Quantifiers.isEXISTS(sentence.getQuantifier())) {
            LinkedHashMap<Variable, Term> skolemSubst = new LinkedHashMap<Variable, Term>();
            for (Variable eVar : sentence.getVariables()) {
                if (universalScope.size() > 0) {
                    String skolemFunctionName = this.parser.getFOLDomain().addSkolemFunction();
                    skolemSubst.put(eVar, new Function(skolemFunctionName, new ArrayList<Term>(universalScope)));
                    continue;
                }
                String skolemConstantName = this.parser.getFOLDomain().addSkolemConstant();
                skolemSubst.put(eVar, new Constant(skolemConstantName));
            }
            Sentence skolemized = this.substVisitor.subst(skolemSubst, quantified);
            return (Sentence)skolemized.accept(this, arg);
        }
        if (Quantifiers.isFORALL(sentence.getQuantifier())) {
            universalScope.addAll(sentence.getVariables());
            Sentence droppedUniversal = (Sentence)quantified.accept(this, arg);
            universalScope.removeAll(sentence.getVariables());
            return droppedUniversal;
        }
        throw new IllegalStateException("Unhandled Quantifier:" + sentence.getQuantifier());
    }
}

