/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.visitors;

import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.NegativeSymbolCollector;
import aima.logic.propositional.visitors.PositiveSymbolCollector;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.SetOps;
import java.util.Set;

public class SymbolClassifier {
    public Set<Symbol> getPositiveSymbolsIn(Sentence sentence) {
        return new PositiveSymbolCollector().getPositiveSymbolsIn(sentence);
    }

    public Set<Symbol> getNegativeSymbolsIn(Sentence sentence) {
        return new NegativeSymbolCollector().getNegativeSymbolsIn(sentence);
    }

    public Set<Symbol> getPureNegativeSymbolsIn(Sentence sentence) {
        Set<Symbol> allNegatives = this.getNegativeSymbolsIn(sentence);
        Set<Symbol> allPositives = this.getPositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().difference(allNegatives, allPositives);
    }

    public Set<Symbol> getPurePositiveSymbolsIn(Sentence sentence) {
        Set<Symbol> allNegatives = this.getNegativeSymbolsIn(sentence);
        Set<Symbol> allPositives = this.getPositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().difference(allPositives, allNegatives);
    }

    public Set<Symbol> getPureSymbolsIn(Sentence sentence) {
        Set<Symbol> allPureNegatives = this.getPureNegativeSymbolsIn(sentence);
        Set<Symbol> allPurePositives = this.getPurePositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().union(allPurePositives, allPureNegatives);
    }

    public Set<Symbol> getImpureSymbolsIn(Sentence sentence) {
        Set<Symbol> allNegatives = this.getNegativeSymbolsIn(sentence);
        Set<Symbol> allPositives = this.getPositiveSymbolsIn(sentence);
        return new SetOps<Symbol>().intersection(allPositives, allNegatives);
    }

    public Set<Symbol> getSymbolsIn(Sentence sentence) {
        return new SymbolCollector().getSymbolsIn(sentence);
    }
}

