/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.reasoning;

import aima.probability.RandomVariable;
import aima.probability.reasoning.SensorModel;
import aima.probability.reasoning.TransitionModel;
import aima.util.Matrix;
import java.util.Arrays;
import java.util.List;

public class HiddenMarkovModel {
    SensorModel sensorModel;
    TransitionModel transitionModel;
    private RandomVariable priorDistribution;

    public HiddenMarkovModel(RandomVariable priorDistribution, TransitionModel tm, SensorModel sm) {
        this.priorDistribution = priorDistribution;
        this.transitionModel = tm;
        this.sensorModel = sm;
    }

    public RandomVariable prior() {
        return this.priorDistribution;
    }

    public RandomVariable predict(RandomVariable aBelief, String action) {
        RandomVariable newBelief = aBelief.duplicate();
        Matrix beliefMatrix = aBelief.asMatrix();
        Matrix transitionMatrix = this.transitionModel.asMatrix(action);
        Matrix predicted = transitionMatrix.transpose().times(beliefMatrix);
        newBelief.updateFrom(predicted);
        return newBelief;
    }

    public RandomVariable perceptionUpdate(RandomVariable aBelief, String perception) {
        RandomVariable newBelief = aBelief.duplicate();
        Matrix beliefMatrix = aBelief.asMatrix();
        Matrix o_matrix = this.sensorModel.asMatrix(perception);
        Matrix updated = o_matrix.times(beliefMatrix);
        newBelief.updateFrom(updated);
        newBelief.normalize();
        return newBelief;
    }

    public RandomVariable forward(RandomVariable aBelief, String action, String perception) {
        return this.perceptionUpdate(this.predict(aBelief, action), perception);
    }

    public RandomVariable forward(RandomVariable aBelief, String perception) {
        return this.forward(aBelief, "do_nothing", perception);
    }

    public RandomVariable calculate_next_backward_message(RandomVariable forwardBelief, RandomVariable present_backward_message, String perception) {
        RandomVariable result = present_backward_message.duplicate();
        Matrix oMatrix = this.sensorModel.asMatrix(perception);
        Matrix transitionMatrix = this.transitionModel.asMatrix();
        Matrix backwardMatrix = transitionMatrix.times(oMatrix.times(present_backward_message.asMatrix()));
        Matrix resultMatrix = backwardMatrix.arrayTimes(forwardBelief.asMatrix());
        result.updateFrom(resultMatrix);
        result.normalize();
        return result;
    }

    public List<RandomVariable> forward_backward(List<String> perceptions) {
        int i;
        RandomVariable[] forwardMessages = new RandomVariable[perceptions.size() + 1];
        RandomVariable backwardMessage = this.priorDistribution.createUnitBelief();
        RandomVariable[] smoothedBeliefs = new RandomVariable[perceptions.size() + 1];
        forwardMessages[0] = this.priorDistribution;
        smoothedBeliefs[0] = null;
        for (i = 0; i < perceptions.size(); ++i) {
            forwardMessages[i + 1] = this.forward(forwardMessages[i], perceptions.get(i));
        }
        for (i = perceptions.size(); i > 0; --i) {
            RandomVariable smoothed = this.priorDistribution.duplicate();
            smoothed.updateFrom(forwardMessages[i].asMatrix().arrayTimes(backwardMessage.asMatrix()));
            smoothed.normalize();
            smoothedBeliefs[i] = smoothed;
            backwardMessage = this.calculate_next_backward_message(forwardMessages[i], backwardMessage, perceptions.get(i - 1));
        }
        return Arrays.asList(smoothedBeliefs);
    }

    public SensorModel sensorModel() {
        return this.sensorModel;
    }

    public TransitionModel transitionModel() {
        return this.transitionModel;
    }
}

