/*
 * Decompiled with CFR 0.152.
 */
package aima.test.coretest;

import aima.basic.Percept;
import aima.basic.simplerule.ANDCondition;
import aima.basic.simplerule.EQUALCondition;
import aima.basic.simplerule.NOTCondition;
import aima.basic.simplerule.ORCondition;
import aima.basic.simplerule.Rule;
import junit.framework.TestCase;

public class RuleTest
extends TestCase {
    public void testEQUALRule() {
        Rule r = new Rule(new EQUALCondition("car-in-front-is-braking", "true"), "initiate-braking");
        RuleTest.assertEquals("initiate-braking", r.getAction());
        RuleTest.assertEquals("if car-in-front-is-braking==true then initiate-braking.", r.toString());
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-braking", "false")));
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-indicating", "true")));
    }

    public void testNOTRule() {
        Rule r = new Rule(new NOTCondition(new EQUALCondition("car-in-front-is-braking", "true")), "initiate-braking");
        RuleTest.assertEquals("initiate-braking", r.getAction());
        RuleTest.assertEquals("if ![car-in-front-is-braking==true] then initiate-braking.", r.toString());
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "false")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-indicating", "true")));
    }

    public void testANDRule() {
        Rule r = new Rule(new ANDCondition(new EQUALCondition("car-in-front-is-braking", "true"), new EQUALCondition("car-in-front-tires-smoking", "true")), "emergency-braking");
        RuleTest.assertEquals("emergency-braking", r.getAction());
        RuleTest.assertEquals("if [car-in-front-is-braking==true && car-in-front-tires-smoking==true] then emergency-braking.", r.toString());
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-braking", "false", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "false")));
    }

    public void testORRule() {
        Rule r = new Rule(new ORCondition(new EQUALCondition("car-in-front-is-braking", "true"), new EQUALCondition("car-in-front-tires-smoking", "true")), "emergency-braking");
        RuleTest.assertEquals("emergency-braking", r.getAction());
        RuleTest.assertEquals("if [car-in-front-is-braking==true || car-in-front-tires-smoking==true] then emergency-braking.", r.toString());
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "true")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "false", "car-in-front-tires-smoking", "true")));
        RuleTest.assertEquals(true, r.evaluate(new Percept("car-in-front-is-braking", "true", "car-in-front-tires-smoking", "false")));
        RuleTest.assertEquals(false, r.evaluate(new Percept("car-in-front-is-braking", "false", "car-in-front-tires-smoking", "false")));
    }
}

