/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.framework.Learner;
import aima.learning.inductive.DecisionTree;
import aima.learning.learners.AdaBoostLearner;
import aima.learning.learners.StumpLearner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class EnsembleLearningTest
extends TestCase {
    private static final String UNABLE_TO_CLASSIFY = "Unable to Classify";
    private static final String YES = "Yes";

    public void testAdaBoostEnablesCollectionOfStumpsToClassifyDataSetAccurately() throws Exception {
        DataSet ds = DataSetFactory.getRestaurantDataSet();
        List<DecisionTree> stumps = DecisionTree.getStumpsFor(ds, YES, "No");
        ArrayList<Learner> learners = new ArrayList<Learner>();
        Iterator<DecisionTree> iterator = stumps.iterator();
        while (iterator.hasNext()) {
            DecisionTree stump;
            DecisionTree sl = stump = iterator.next();
            StumpLearner stumpLearner = new StumpLearner(sl, "No");
            learners.add(stumpLearner);
        }
        AdaBoostLearner learner = new AdaBoostLearner(learners, ds);
        learner.train(ds);
        int[] result = learner.test(ds);
        EnsembleLearningTest.assertEquals(12, result[0]);
        EnsembleLearningTest.assertEquals(0, result[1]);
    }
}

