/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.inference.Demodulation;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.TermEquality;
import java.util.ArrayList;
import junit.framework.TestCase;

public class DemodulationTest
extends TestCase {
    private Demodulation demodulation = null;

    @Override
    public void setUp() {
        this.demodulation = new Demodulation();
    }

    public void testSimpleAtomicExamples() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addConstant("E");
        domain.addPredicate("P");
        domain.addFunction("F");
        domain.addFunction("G");
        domain.addFunction("H");
        domain.addFunction("J");
        FOLParser parser = new FOLParser(domain);
        Predicate expression = (Predicate)parser.parse("P(A,F(B,G(A,H(B)),C),D)");
        TermEquality assertion = (TermEquality)parser.parse("B = E");
        Predicate altExpression = (Predicate)this.demodulation.apply(assertion, expression);
        DemodulationTest.assertFalse(expression.equals(altExpression));
        DemodulationTest.assertEquals("P(A,F(E,G(A,H(B)),C),D)", altExpression.toString());
        altExpression = (Predicate)this.demodulation.apply(assertion, altExpression);
        DemodulationTest.assertEquals("P(A,F(E,G(A,H(E)),C),D)", altExpression.toString());
        assertion = (TermEquality)parser.parse("G(x,y) = J(x)");
        altExpression = (Predicate)this.demodulation.apply(assertion, expression);
        DemodulationTest.assertEquals("P(A,F(B,J(A),C),D)", altExpression.toString());
    }

    public void testSimpleAtomicNonExample() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addConstant("E");
        domain.addPredicate("P");
        domain.addFunction("F");
        domain.addFunction("G");
        domain.addFunction("H");
        domain.addFunction("J");
        FOLParser parser = new FOLParser(domain);
        Predicate expression = (Predicate)parser.parse("P(A,G(x,B),C)");
        TermEquality assertion = (TermEquality)parser.parse("G(A,y) = J(y)");
        Predicate altExpression = (Predicate)this.demodulation.apply(assertion, expression);
        DemodulationTest.assertNull(altExpression);
    }

    public void testSimpleClauseExamples() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addConstant("D");
        domain.addConstant("E");
        domain.addPredicate("P");
        domain.addPredicate("Q");
        domain.addPredicate("W");
        domain.addFunction("F");
        domain.addFunction("G");
        domain.addFunction("H");
        domain.addFunction("J");
        FOLParser parser = new FOLParser(domain);
        ArrayList<Literal> lits = new ArrayList<Literal>();
        Predicate p1 = (Predicate)parser.parse("Q(z, G(D,B))");
        Predicate p2 = (Predicate)parser.parse("P(x, G(A,C))");
        Predicate p3 = (Predicate)parser.parse("W(z,x,u,w,y)");
        lits.add(new Literal(p1));
        lits.add(new Literal(p2));
        lits.add(new Literal(p3));
        Clause clExpression = new Clause(lits);
        TermEquality assertion = (TermEquality)parser.parse("G(x,y) = x");
        Clause altClExpression = this.demodulation.apply(assertion, clExpression);
        DemodulationTest.assertEquals("[P(x,G(A,C)), Q(z,D), W(z,x,u,w,y)]", altClExpression.toString());
        altClExpression = this.demodulation.apply(assertion, altClExpression);
        DemodulationTest.assertEquals("[P(x,A), Q(z,D), W(z,x,u,w,y)]", altClExpression.toString());
    }

    public void testSimpleClauseNonExample() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addPredicate("P");
        domain.addFunction("F");
        FOLParser parser = new FOLParser(domain);
        ArrayList<Literal> lits = new ArrayList<Literal>();
        Predicate p1 = (Predicate)parser.parse("P(y, F(A,y))");
        lits.add(new Literal(p1));
        Clause clExpression = new Clause(lits);
        TermEquality assertion = (TermEquality)parser.parse("F(x,B) = C");
        Clause altClExpression = this.demodulation.apply(assertion, clExpression);
        DemodulationTest.assertNull(altClExpression);
    }

    public void testBypassReflexivityAxiom() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addPredicate("P");
        domain.addFunction("F");
        FOLParser parser = new FOLParser(domain);
        ArrayList<Literal> lits = new ArrayList<Literal>();
        Predicate p1 = (Predicate)parser.parse("P(y, F(A,y))");
        lits.add(new Literal(p1));
        Clause clExpression = new Clause(lits);
        TermEquality assertion = (TermEquality)parser.parse("x = x");
        Clause altClExpression = this.demodulation.apply(assertion, clExpression);
        DemodulationTest.assertNull(altClExpression);
    }
}

