/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.algorithms.PLResolution;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import java.util.Set;
import junit.framework.TestCase;

public class PLResolutionTest
extends TestCase {
    private PLResolution resolution;
    private PEParser parser;

    @Override
    public void setUp() {
        this.resolution = new PLResolution();
        this.parser = new PEParser();
    }

    public void testPLResolveWithOneLiteralMatching() {
        Sentence one = (Sentence)this.parser.parse("(A OR B)");
        Sentence two = (Sentence)this.parser.parse("((NOT B) OR C)");
        Sentence expected = (Sentence)this.parser.parse("(A OR C)");
        Set<Sentence> resolvents = this.resolution.plResolve(one, two);
        PLResolutionTest.assertEquals(1, resolvents.size());
        PLResolutionTest.assertTrue(resolvents.contains(expected));
    }

    public void testPLResolveWithNoLiteralMatching() {
        Sentence one = (Sentence)this.parser.parse("(A OR B)");
        Sentence two = (Sentence)this.parser.parse("(C OR D)");
        Set<Sentence> resolvents = this.resolution.plResolve(one, two);
        PLResolutionTest.assertEquals(0, resolvents.size());
    }

    public void testPLResolveWithOneLiteralSentencesMatching() {
        Sentence one = (Sentence)this.parser.parse("A");
        Sentence two = (Sentence)this.parser.parse("(NOT A)");
        Set<Sentence> resolvents = this.resolution.plResolve(one, two);
        PLResolutionTest.assertEquals(1, resolvents.size());
        PLResolutionTest.assertTrue(resolvents.contains(new Symbol("EMPTY_CLAUSE")));
    }

    public void testPLResolveWithTwoLiteralsMatching() {
        Sentence one = (Sentence)this.parser.parse("((NOT P21) OR B11)");
        Sentence two = (Sentence)this.parser.parse("(((NOT B11) OR P21) OR P12)");
        Sentence expected1 = (Sentence)this.parser.parse("(  ( P12 OR P21 ) OR  ( NOT P21 )  )");
        Sentence expected2 = (Sentence)this.parser.parse("(  ( B11 OR P12 ) OR  ( NOT B11 )  )");
        Set<Sentence> resolvents = this.resolution.plResolve(one, two);
        PLResolutionTest.assertEquals(2, resolvents.size());
        PLResolutionTest.assertTrue(resolvents.contains(expected1));
        PLResolutionTest.assertTrue(resolvents.contains(expected2));
    }

    public void testPLResolve1() {
        boolean b = this.resolution.plResolution("((B11 =>  (NOT P11)) AND B11)", "(P11)");
        PLResolutionTest.assertEquals(false, b);
    }

    public void testPLResolve2() {
        boolean b = this.resolution.plResolution("(A AND B)", "B");
        PLResolutionTest.assertEquals(true, b);
    }

    public void testPLResolve3() {
        boolean b = this.resolution.plResolution("((B11 =>  (NOT P11)) AND B11)", "(NOT P11)");
        PLResolutionTest.assertEquals(true, b);
    }

    public void testPLResolve4() {
        boolean b = this.resolution.plResolution("(A OR B)", "B");
        PLResolutionTest.assertEquals(false, b);
    }

    public void testPLResolve5() {
        boolean b = this.resolution.plResolution("((B11 =>  (NOT P11)) AND B11)", "(NOT B11)");
        PLResolutionTest.assertEquals(false, b);
    }

    public void testMultipleClauseResolution() {
        PLResolution plr = new PLResolution();
        KnowledgeBase kb = new KnowledgeBase();
        String fact = "((B11 <=> (P12 OR P21)) AND (NOT B11))";
        kb.tell(fact);
        plr.plResolution(kb, "(B)");
    }
}

