/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.parser;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.AtomicSentence;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.FalseSentence;
import aima.logic.propositional.parsing.ast.MultiSentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.parsing.ast.TrueSentence;
import aima.logic.propositional.parsing.ast.UnarySentence;
import junit.framework.TestCase;

public class PEParserTest
extends TestCase {
    private PEParser parser;

    @Override
    public void setUp() {
        this.parser = new PEParser();
    }

    public void testAtomicSentenceTrueParse() {
        AtomicSentence sen = (AtomicSentence)this.parser.parse("true");
        PEParserTest.assertEquals(TrueSentence.class, sen.getClass());
        sen = (AtomicSentence)this.parser.parse("(true)");
        PEParserTest.assertEquals(TrueSentence.class, sen.getClass());
        sen = (AtomicSentence)this.parser.parse("((true))");
        PEParserTest.assertEquals(TrueSentence.class, sen.getClass());
    }

    public void testAtomicSentenceFalseParse() {
        AtomicSentence sen = (AtomicSentence)this.parser.parse("faLse");
        PEParserTest.assertEquals(FalseSentence.class, sen.getClass());
    }

    public void testAtomicSentenceSymbolParse() {
        AtomicSentence sen = (AtomicSentence)this.parser.parse("AIMA");
        PEParserTest.assertEquals(Symbol.class, sen.getClass());
    }

    public void testNotSentenceParse() {
        UnarySentence sen = (UnarySentence)this.parser.parse("NOT AIMA");
        PEParserTest.assertEquals(UnarySentence.class, sen.getClass());
    }

    public void testBinarySentenceParse() {
        BinarySentence sen = (BinarySentence)this.parser.parse("(PETER  AND  NORVIG)");
        PEParserTest.assertEquals(BinarySentence.class, sen.getClass());
    }

    public void testMultiSentenceAndParse() {
        MultiSentence sen = (MultiSentence)this.parser.parse("(AND  NORVIG AIMA LISP)");
        PEParserTest.assertEquals(MultiSentence.class, sen.getClass());
    }

    public void testMultiSentenceOrParse() {
        MultiSentence sen = (MultiSentence)this.parser.parse("(OR  NORVIG AIMA LISP)");
        PEParserTest.assertEquals(MultiSentence.class, sen.getClass());
    }

    public void testMultiSentenceBracketedParse() {
        MultiSentence sen = (MultiSentence)this.parser.parse("((OR  NORVIG AIMA LISP))");
        PEParserTest.assertEquals(MultiSentence.class, sen.getClass());
    }

    public void testComplexSentenceParse() {
        BinarySentence sen = (BinarySentence)this.parser.parse("((OR  NORVIG AIMA LISP) AND TRUE)");
        PEParserTest.assertEquals(BinarySentence.class, sen.getClass());
        sen = (BinarySentence)this.parser.parse("((OR  NORVIG AIMA LISP) AND (((LISP => COOL))))");
        PEParserTest.assertEquals(BinarySentence.class, sen.getClass());
        PEParserTest.assertEquals(" ( ( OR NORVIG AIMA LISP  )  AND  ( LISP => COOL ) )", sen.toString());
        String s = "((NOT (P AND Q ))  AND ((NOT (R AND S))))";
        sen = (BinarySentence)this.parser.parse(s);
        PEParserTest.assertEquals(" (  ( NOT  ( P AND Q ) )  AND  ( NOT  ( R AND S ) )  )", sen.toString());
        s = "((P AND Q) OR (S AND T))";
        sen = (BinarySentence)this.parser.parse(s);
        PEParserTest.assertEquals(" (  ( P AND Q ) OR  ( S AND T ) )", sen.toString());
        PEParserTest.assertEquals("OR", sen.getOperator());
        s = "(NOT ((P AND Q) => (S AND T)))";
        UnarySentence nsen = (UnarySentence)this.parser.parse(s);
        s = "(NOT (P <=> (S AND T)))";
        nsen = (UnarySentence)this.parser.parse(s);
        PEParserTest.assertEquals(" ( NOT  ( P <=>  ( S AND T ) ) ) ", nsen.toString());
        s = "(P <=> (S AND T))";
        sen = (BinarySentence)this.parser.parse(s);
        s = "(P => Q)";
        sen = (BinarySentence)this.parser.parse(s);
        s = "((P AND Q) => R)";
        sen = (BinarySentence)this.parser.parse(s);
    }
}

