/*
 * Decompiled with CFR 0.152.
 */
package aima.test.probdecisiontest;

import aima.probability.Randomizer;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPFactory;
import aima.probability.decision.MDPPolicy;
import aima.probability.decision.MDPUtilityFunction;
import aima.probability.decision.cellworld.CellWorldPosition;
import junit.framework.TestCase;

public class PolicyIterationTest
extends TestCase {
    private MDP<CellWorldPosition, String> fourByThreeMDP;
    private Randomizer alwaysLessThanEightyPercent;

    @Override
    public void setUp() {
        this.fourByThreeMDP = MDPFactory.createFourByThreeMDP();
    }

    public void testPolicyEvaluation() {
        MDPPolicy<CellWorldPosition, String> policy = this.fourByThreeMDP.randomPolicy();
        MDPUtilityFunction<CellWorldPosition> uf1 = this.fourByThreeMDP.initialUtilityFunction();
        MDPUtilityFunction<CellWorldPosition> uf2 = this.fourByThreeMDP.policyEvaluation(policy, uf1, 1.0, 3);
        PolicyIterationTest.assertFalse(uf1.equals(uf2));
    }

    public void testPolicyIteration() {
        MDPPolicy<CellWorldPosition, String> policy = this.fourByThreeMDP.policyIteration(1.0);
        PolicyIterationTest.assertEquals("up", policy.getAction(new CellWorldPosition(1, 1)));
        PolicyIterationTest.assertEquals("up", policy.getAction(new CellWorldPosition(2, 1)));
        PolicyIterationTest.assertEquals("right", policy.getAction(new CellWorldPosition(3, 1)));
        PolicyIterationTest.assertEquals("left", policy.getAction(new CellWorldPosition(1, 2)));
        PolicyIterationTest.assertEquals("right", policy.getAction(new CellWorldPosition(3, 2)));
        PolicyIterationTest.assertEquals("left", policy.getAction(new CellWorldPosition(1, 3)));
        PolicyIterationTest.assertEquals("up", policy.getAction(new CellWorldPosition(2, 3)));
        PolicyIterationTest.assertEquals("right", policy.getAction(new CellWorldPosition(3, 3)));
        PolicyIterationTest.assertEquals("left", policy.getAction(new CellWorldPosition(1, 4)));
    }
}

