/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.map;

import aima.search.map.ExtendableMap;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class MapTest
extends TestCase {
    ExtendableMap aMap;

    @Override
    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 5.0);
        this.aMap.addBidirectionalLink("A", "C", 6.0);
        this.aMap.addBidirectionalLink("B", "C", 4.0);
        this.aMap.addBidirectionalLink("C", "D", 7.0);
        this.aMap.addUnidirectionalLink("B", "E", 14.0);
    }

    public void testLocationsLinkedTo() {
        ArrayList<String> locations = new ArrayList<String>();
        List<String> linkedTo = this.aMap.getLocationsLinkedTo("A");
        locations.clear();
        locations.add("B");
        locations.add("C");
        MapTest.assertTrue(locations.containsAll(linkedTo) && linkedTo.size() == 2);
        linkedTo = this.aMap.getLocationsLinkedTo("B");
        locations.clear();
        locations.add("A");
        locations.add("C");
        locations.add("E");
        MapTest.assertTrue(locations.containsAll(linkedTo) && linkedTo.size() == 3);
        linkedTo = this.aMap.getLocationsLinkedTo("C");
        locations.clear();
        locations.add("A");
        locations.add("B");
        locations.add("D");
        MapTest.assertTrue(locations.containsAll(linkedTo) && linkedTo.size() == 3);
        linkedTo = this.aMap.getLocationsLinkedTo("D");
        locations.clear();
        locations.add("C");
        MapTest.assertTrue(locations.containsAll(linkedTo) && linkedTo.size() == 1);
        linkedTo = this.aMap.getLocationsLinkedTo("E");
        MapTest.assertTrue(linkedTo.size() == 0);
    }

    public void testDistances() {
        MapTest.assertEquals(new Double(5.0), this.aMap.getDistance("A", "B"));
        MapTest.assertEquals(new Double(6.0), this.aMap.getDistance("A", "C"));
        MapTest.assertEquals(new Double(4.0), this.aMap.getDistance("B", "C"));
        MapTest.assertEquals(new Double(7.0), this.aMap.getDistance("C", "D"));
        MapTest.assertEquals(new Double(14.0), this.aMap.getDistance("B", "E"));
        MapTest.assertEquals(new Double(5.0), this.aMap.getDistance("B", "A"));
        MapTest.assertEquals(new Double(6.0), this.aMap.getDistance("C", "A"));
        MapTest.assertEquals(new Double(4.0), this.aMap.getDistance("C", "B"));
        MapTest.assertEquals(new Double(7.0), this.aMap.getDistance("D", "C"));
        MapTest.assertNull(this.aMap.getDistance("X", "Z"));
        MapTest.assertNull(this.aMap.getDistance("A", "Z"));
        MapTest.assertNull(this.aMap.getDistance("A", "E"));
        MapTest.assertNull(this.aMap.getDistance("E", "B"));
    }

    public void testRandomGeneration() {
        ArrayList<String> locations = new ArrayList<String>();
        locations.add("A");
        locations.add("B");
        locations.add("C");
        locations.add("D");
        locations.add("E");
        for (int i = 0; i < locations.size(); ++i) {
            MapTest.assertTrue(locations.contains(this.aMap.randomlyGenerateDestination()));
        }
    }
}

