/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.nqueens;

import aima.basic.XYLocation;
import aima.search.nqueens.NQueensBoard;
import junit.framework.TestCase;

public class NQueensBoardTest
extends TestCase {
    NQueensBoard board;

    @Override
    public void setUp() {
        this.board = new NQueensBoard(8);
    }

    public void testBasics() {
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfQueensOnBoard());
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfQueensOnBoard());
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfQueensOnBoard());
        this.board.addQueenAt(new XYLocation(1, 1));
        NQueensBoardTest.assertEquals(2, this.board.getNumberOfQueensOnBoard());
        NQueensBoardTest.assertTrue(this.board.queenExistsAt(new XYLocation(1, 1)));
        NQueensBoardTest.assertTrue(this.board.queenExistsAt(new XYLocation(0, 0)));
        this.board.moveQueen(new XYLocation(1, 1), new XYLocation(3, 3));
        NQueensBoardTest.assertTrue(this.board.queenExistsAt(new XYLocation(3, 3)));
        NQueensBoardTest.assertTrue(!this.board.queenExistsAt(new XYLocation(1, 1)));
        NQueensBoardTest.assertEquals(2, this.board.getNumberOfQueensOnBoard());
    }

    public void testCornerQueenAttack1() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(false, this.board.isSquareUnderAttack(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(1, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(7, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(0, 7)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(1, 1)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(2, 2)));
        NQueensBoardTest.assertEquals(false, this.board.isSquareUnderAttack(new XYLocation(2, 1)));
        NQueensBoardTest.assertEquals(false, this.board.isSquareUnderAttack(new XYLocation(1, 2)));
    }

    public void testCornerQueenAttack2() {
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(7, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(0, 7)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(7, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(6, 6)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(5, 5)));
        NQueensBoardTest.assertEquals(false, this.board.isSquareUnderAttack(new XYLocation(6, 5)));
        NQueensBoardTest.assertEquals(false, this.board.isSquareUnderAttack(new XYLocation(5, 6)));
    }

    public void testEdgeQueenAttack() {
        this.board.addQueenAt(new XYLocation(0, 3));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(0, 7)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(7, 3)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(3, 0)));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(4, 7)));
    }

    public void testAttack2() {
        this.board.addQueenAt(new XYLocation(7, 0));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(6, 1)));
    }

    public void testAttack3() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(true, this.board.isSquareUnderAttack(new XYLocation(0, 1)));
    }

    public void testAttack4() {
        this.board.addQueenAt(new XYLocation(0, 2));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(1, 1)));
    }

    public void testMidBoardDiagonalAttack() {
        this.board.addQueenAt(new XYLocation(3, 3));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(4, 2)));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(4, 4)));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(2, 2)));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(2, 4)));
    }

    public void testCornerDiagonalAttack() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(1, 1)));
        this.board.clear();
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(6, 6)));
    }

    public void testAttack6() {
        this.board.addQueenAt(new XYLocation(1, 6));
        NQueensBoardTest.assertTrue(this.board.isSquareUnderAttack(new XYLocation(0, 7)));
    }

    public void testRemoveQueen() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfQueensOnBoard());
        this.board.removeQueenFrom(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfQueensOnBoard());
    }

    public void testMoveQueen() {
        XYLocation from = new XYLocation(0, 0);
        XYLocation to = new XYLocation(1, 1);
        this.board.addQueenAt(from);
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfQueensOnBoard());
        NQueensBoardTest.assertTrue(this.board.queenExistsAt(from));
        NQueensBoardTest.assertFalse(this.board.queenExistsAt(to));
        this.board.moveQueen(from, to);
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfQueensOnBoard());
        NQueensBoardTest.assertFalse(this.board.queenExistsAt(from));
        NQueensBoardTest.assertTrue(this.board.queenExistsAt(to));
    }

    public void testMoveNonExistentQueen() {
        XYLocation from = new XYLocation(0, 0);
        XYLocation to = new XYLocation(1, 1);
        this.board.moveQueen(from, to);
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfQueensOnBoard());
    }

    public void testRemoveNonExistentQueen() {
        this.board.removeQueenFrom(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfQueensOnBoard());
    }

    public void testEquality() {
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoard board2 = new NQueensBoard(8);
        board2.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(this.board, board2);
        NQueensBoard board3 = new NQueensBoard(8);
        board3.addQueenAt(new XYLocation(0, 1));
        NQueensBoardTest.assertFalse(this.board.equals(board3));
    }

    public void testPrint() {
        NQueensBoard board2 = new NQueensBoard(2);
        board2.addQueenAt(new XYLocation(0, 0));
        String expected = " Q  - \n -  - \n";
        NQueensBoardTest.assertEquals(expected, board2.getBoardPic());
    }

    public void testDontPlaceTwoQueensOnOneSquare() {
        this.board.addQueenAt(new XYLocation(0, 0));
        this.board.addQueenAt(new XYLocation(0, 0));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfQueensOnBoard());
    }

    public void testSimpleHorizontalAttack() {
        XYLocation loc = new XYLocation(0, 0);
        this.board.addQueenAt(loc);
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfAttacksOn(loc));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(1, 0)));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc.right()));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(7, 0)));
    }

    public void testSimpleVerticalAttack() {
        XYLocation loc = new XYLocation(0, 0);
        this.board.addQueenAt(loc);
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfAttacksOn(loc));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc.down()));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(0, 7)));
    }

    public void testSimpleDiagonalAttack() {
        XYLocation loc = new XYLocation(3, 3);
        this.board.addQueenAt(loc);
        NQueensBoardTest.assertEquals(0, this.board.getNumberOfAttacksOn(loc));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc.down().right()));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc.down().left()));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc.up().left()));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc.up().right()));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(7, 7)));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(0, 0)));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(6, 0)));
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(new XYLocation(0, 6)));
    }

    public void testMultipleQueens() {
        XYLocation loc1 = new XYLocation(3, 3);
        this.board.addQueenAt(loc1);
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc1.right()));
        this.board.addQueenAt(loc1.right().right());
        NQueensBoardTest.assertEquals(1, this.board.getNumberOfAttacksOn(loc1));
        NQueensBoardTest.assertEquals(2, this.board.getNumberOfAttacksOn(loc1.right()));
        this.board.addQueenAt(loc1.right().down());
        NQueensBoardTest.assertEquals(2, this.board.getNumberOfAttacksOn(loc1));
        NQueensBoardTest.assertEquals(3, this.board.getNumberOfAttacksOn(loc1.right()));
        NQueensBoardTest.assertEquals(2, this.board.getNumberOfAttacksOn(loc1.right().right()));
    }

    public void testBoardDisplay() {
        this.board.addQueenAt(new XYLocation(0, 5));
        this.board.addQueenAt(new XYLocation(1, 6));
        this.board.addQueenAt(new XYLocation(2, 1));
        this.board.addQueenAt(new XYLocation(3, 3));
        this.board.addQueenAt(new XYLocation(4, 6));
        this.board.addQueenAt(new XYLocation(5, 4));
        this.board.addQueenAt(new XYLocation(6, 7));
        this.board.addQueenAt(new XYLocation(7, 7));
        NQueensBoardTest.assertEquals(" -  -  -  -  -  -  -  - \n -  -  Q  -  -  -  -  - \n -  -  -  -  -  -  -  - \n -  -  -  Q  -  -  -  - \n -  -  -  -  -  Q  -  - \n Q  -  -  -  -  -  -  - \n -  Q  -  -  Q  -  -  - \n -  -  -  -  -  -  Q  Q \n", this.board.getBoardPic());
        NQueensBoardTest.assertEquals("--------\n--Q-----\n--------\n---Q----\n-----Q--\nQ-------\n-Q--Q---\n------QQ\n", this.board.toString());
    }
}

