/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXDrawersStack$$Lambda$1;
import com.jfoenix.controls.JFXDrawersStack$$Lambda$2;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

@DefaultProperty(value="content")
public class JFXDrawersStack
extends Region {
    private List<JFXDrawer> drawers = new ArrayList<JFXDrawer>();
    private Node content;
    private boolean performingLayout;

    public JFXDrawersStack() {
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
    }

    public void requestLayout() {
        if (this.performingLayout) {
            return;
        }
        super.requestLayout();
    }

    protected void layoutChildren() {
        this.performingLayout = true;
        List managed = this.getManagedChildren();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = this.getInsets().getTop();
        double right = this.getInsets().getRight();
        double left = this.getInsets().getLeft();
        double bottom = this.getInsets().getBottom();
        double contentWidth = width - left - right;
        double contentHeight = height - top - bottom;
        int size = managed.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)managed.get(i);
            this.layoutInArea(child, left, top, contentWidth, contentHeight, 0.0, Insets.EMPTY, HPos.CENTER, VPos.CENTER);
        }
        this.performingLayout = false;
    }

    public Node getContent() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content = content;
        if (this.drawers.size() > 0) {
            this.drawers.get(0).setContent(content);
        } else {
            this.getChildren().add((Object)this.content);
        }
    }

    public void addDrawer(JFXDrawer drawer) {
        if (drawer == null) {
            return;
        }
        if (this.drawers.isEmpty()) {
            if (this.content != null) {
                drawer.setContent(this.content);
            }
        } else {
            drawer.setContent((Node)this.drawers.get(this.drawers.size() - 1));
        }
        this.drawers.add(drawer);
        this.getChildren().setAll((Object[])new Node[]{drawer});
        drawer.setPickOnBounds(false);
        JFXNodeUtils.addPressAndHoldHandler((Node)drawer.sidePane, Duration.millis((double)300.0), (EventHandler<MouseEvent>)JFXDrawersStack$$Lambda$1.lambdaFactory$(this, drawer));
    }

    private void updateDrawerPosition(JFXDrawer drawer) {
        int index = this.drawers.indexOf((Object)drawer);
        if (index + 1 < this.drawers.size()) {
            if (index - 1 >= 0) {
                this.drawers.get(index + 1).setContent((Node)this.drawers.get(index - 1));
            } else if (index == 0) {
                this.drawers.get(index + 1).setContent(this.content);
            }
            drawer.setContent((Node)this.drawers.get(this.drawers.size() - 1));
            this.drawers.remove((Object)drawer);
            this.drawers.add(drawer);
            this.getChildren().setAll((Object[])new Node[]{drawer});
        }
    }

    public void toggle(JFXDrawer drawer) {
        if (!this.drawers.contains((Object)drawer)) {
            this.addDrawer(drawer);
        }
        if (drawer.isOpened() || drawer.isOpening()) {
            drawer.close();
        } else {
            this.updateDrawerPosition(drawer);
            drawer.open();
        }
    }

    public void toggle(JFXDrawer drawer, boolean show) {
        if (!this.drawers.contains((Object)drawer)) {
            this.addDrawer(drawer);
        }
        if (!show) {
            if (drawer.isOpened() || drawer.isOpening()) {
                drawer.close();
            }
        } else if (!drawer.isOpened() && !drawer.isOpening()) {
            this.updateDrawerPosition(drawer);
            drawer.open();
        }
    }

    static /* synthetic */ void lambda$addDrawer$1(JFXDrawersStack this_, JFXDrawer drawer, MouseEvent event) {
        if (this_.drawers.indexOf((Object)drawer) < this_.drawers.size() - 1) {
            drawer.bringToFront((Callback<Void, Void>)JFXDrawersStack$$Lambda$2.lambdaFactory$(this_, drawer));
        }
    }

    static /* synthetic */ Void lambda$null$0(JFXDrawersStack this_, JFXDrawer drawer, Void param) {
        this_.updateDrawerPosition(drawer);
        return param;
    }
}

