/*
 * Decompiled with CFR 0.152.
 */
package gui;

import graph.VisGraph;
import javafx.concurrent.Worker;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

class Browser
extends Region {
    private final WebView browser = new WebView();
    private final WebEngine webEngine = this.browser.getEngine();
    private VisGraph graph;

    public Browser(VisGraph g) {
        this.graph = g;
        this.getStyleClass().add((Object)"browser");
        this.webEngine.load(((Object)((Object)this)).getClass().getClassLoader().getResource("baseGraph.html").toString());
        this.getChildren().add((Object)this.browser);
        this.setGraph();
    }

    private void setGraph() {
        String script = "setTheData(" + this.graph.getNodesJson() + "," + this.graph.getEdgesJson() + ")";
        this.webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                this.webEngine.executeScript(script);
            }
        });
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.getHeight();
        this.layoutInArea((Node)this.browser, 0.0, 0.0, w, h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected double computePrefWidth(double height) {
        return 750.0;
    }

    protected double computePrefHeight(double width) {
        return 500.0;
    }
}

