/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import mcgraphresolver.utils.Utils;

public class DownloadingDialogController
implements Initializable {
    public Utils utils = new Utils();
    public Label lblContent;
    public BorderPane bpDialog;
    public JFXButton btnCancel;
    public JFXProgressBar progressBar;
    private boolean success = false;
    private ResourceBundle resourceBundle;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
    }

    public void setContent(String text) {
        this.lblContent.setText(text);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void downloadUpdate(String filenameToDownloadWithExtension) {
        Runnable task = () -> this.runTask(filenameToDownloadWithExtension);
        Thread backgroundThread = new Thread(task);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void runTask(String filenameToDownloadWithExtension) {
        String FILE_URL = String.format("%s/%s", "http://provadatabaseandroid.altervista.org/javaFxFolderForDeploy/MCGraphResolver/releases", filenameToDownloadWithExtension);
        try (BufferedInputStream in = new BufferedInputStream(new URL(FILE_URL).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(String.format("%s%s%s", new File(".").getAbsolutePath(), System.getProperty("file.separator"), filenameToDownloadWithExtension));){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            int totalBytesRead = 0;
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
                int finalTotalBytesRead = totalBytesRead += bytesRead;
                Platform.runLater(() -> this.lblContent.setText(String.format(this.resourceBundle.getString("text_progress_download"), (double)finalTotalBytesRead / 1024.0, " Kb")));
            }
        }
        catch (IOException e) {
            this.progressBar.setVisible(false);
            this.lblContent.setText("Download error!");
            this.success = false;
            return;
        }
        this.progressBar.setVisible(false);
        Platform.runLater(() -> this.lblContent.setText(this.resourceBundle.getString("text_download_complete")));
        this.success = true;
        Platform.runLater(() -> {
            this.btnCancel.setText(this.resourceBundle.getString("text_ok"));
            this.btnCancel.setStyle("-fx-background-color: #00c853");
            this.btnCancel.setOnAction(event -> {
                Node source = (Node)event.getSource();
                Stage stage = (Stage)source.getScene().getWindow();
                stage.close();
            });
        });
    }

    @FXML
    public void handleNegativeAction(ActionEvent event) {
        this.success = false;
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }
}

