/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.HostServices;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class HelpController
implements Initializable {
    public Utils utils = new Utils();
    public ListView listHelpGeneral;
    public ListView listHelpShortcut;
    public ListView listHelpRules;
    public JFXButton btnSeeDocumentation;
    private HostServices hostServices;
    private ResourceBundle resourceBundle;
    private SharePreferencesHandler sharePreferencesHandler;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
        this.sharePreferencesHandler = new SharePreferencesHandler();
        String[] rs_array_help = new String[]{this.resourceBundle.getString("text_add_generic_node"), this.resourceBundle.getString("text_add_source_node"), this.resourceBundle.getString("text_add_destination_node"), this.resourceBundle.getString("text_handle_links"), this.resourceBundle.getString("text_double_click_node"), this.resourceBundle.getString("text_right_mouse_click_node"), this.resourceBundle.getString("text_middle_mouse_drag")};
        String[] rs_array_help_shortcut = new String[]{this.resourceBundle.getString("text_alt_g"), this.resourceBundle.getString("text_alt_s"), this.resourceBundle.getString("text_alt_d"), this.resourceBundle.getString("text_alt_l"), this.resourceBundle.getString("text_alt_p"), this.resourceBundle.getString("text_alt_w"), this.resourceBundle.getString("text_alt_e"), this.resourceBundle.getString("text_alt_a")};
        String[] rs_array_help_rules = new String[]{String.format(this.resourceBundle.getString("text_max_num_source_node"), this.sharePreferencesHandler.getMaxNumSourceNodes()), String.format(this.resourceBundle.getString("text_max_num_destination_node"), this.sharePreferencesHandler.getMaxNumDestinationNodes()), String.format(this.resourceBundle.getString("text_estimate_value_format"), 0.0, 999999.99), String.format(this.resourceBundle.getString("text_max_lenght_label"), 20), String.format(this.resourceBundle.getString("text_import_export_format_file"), "mc")};
        for (String s : rs_array_help) {
            this.listHelpGeneral.getItems().add((Object)this.createItemList(s));
        }
        for (String s : rs_array_help_shortcut) {
            this.listHelpShortcut.getItems().add((Object)this.createItemList(s));
        }
        for (String s : rs_array_help_rules) {
            this.listHelpRules.getItems().add((Object)this.createItemList(s));
        }
        this.btnSeeDocumentation.setOnAction(run -> this.hostServices.showDocument("http://provadatabaseandroid.altervista.org/javaFxFolderForDeploy/MCGraphResolver/documentation/Documentazione.pdf"));
    }

    public void setHostServices(HostServices hostServices) {
        this.hostServices = hostServices;
    }

    public void setSharePreferencesHandles(SharePreferencesHandler sharePreferencesHandler) {
        this.sharePreferencesHandler = sharePreferencesHandler;
    }

    private HBox createItemList(String s) {
        HBox hBox = new HBox();
        hBox.setSpacing(5.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        Circle circle = new Circle(3.0);
        circle.setFill((Paint)Color.WHITE);
        Label text = new Label("" + s);
        text.setTextFill((Paint)Color.WHITE);
        text.setPrefWidth(250.0);
        text.setWrapText(true);
        hBox.getChildren().add((Object)circle);
        hBox.getChildren().add((Object)text);
        return hBox;
    }

    @FXML
    private void handleExitAction(ActionEvent event) {
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }
}

