/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.utils;

import java.util.prefs.Preferences;

public class SharePreferencesHandler {
    private Preferences preferences;
    public static final String FIRST_LAUNCH = "first_launch";
    public static final String DEFAULT_FOLDER_FOR_IMPORT_EXPORT = "default_folder_for_import_export";
    public static final String DEFAULT_FOLDER_FOR_SNAPSHOT = "default_folder_for_snapshot";
    public static final String DEFAULT_FOLDER_FOR_SNAPSHOT_PDF = "default_folder_for_snapshot_pdf";
    public static final String COLOR_SOURCE_NODE = "color_source_node";
    public static final String COLOR_DESTINATION_NODE = "color_destination_node";
    public static final String COLOR_GENERIC_NODE = "color_generic_node";
    public static final String COLOR_EDGE = "color_edge";
    public static final String COLOR_WEIGHT = "color_weight";
    public static final String COLOR_LABEL_INSIDE_NODE = "color_label_inside_node";
    public static final String COLOR_ESTIMATE = "color_estimate";
    public static final String MAX_NUM_SOURCE_NODES = "max_num_source_nodes";
    public static final String MAX_NUM_DESTINATION_NODES = "max_num_destination_nodes";
    public static final String MAX_VALUE_FOR_RANDOM_WEIGHT = "max_value_for_random_weight";
    public static final String MIN_VALUE_FOR_RANDOM_WEIGHT = "min_value_for_random_weight";
    public static final String MAX_VALUE_FOR_RANDOM_ESTIMATE = "max_value_for_random_estimate";
    public static final String MIN_VALUE_FOR_RANDOM_ESTIMATE = "min_value_for_random_estimate";
    public static final String FRINGE_ORDERED_BY_NODE_LABEL_DESC = "fringe_order_by_node_label_desc";
    public static final String DUPLICATE_NODE_CHECKING_ENABLE = "duplicate_node_checking_enabled";
    public static final String COMPLETE_SNAPSHOT = "complete_snapshot";
    public static final String SNAPSHOT_PDF_ENABLE = "snapshot_pdf_enabled";

    public void setColorResource(String colorResource, String colorValue) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.put(colorResource, colorValue);
    }

    public String getDefaultFolderForImportExport(String defaultLocation) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.get(DEFAULT_FOLDER_FOR_IMPORT_EXPORT, defaultLocation);
    }

    public void setDefaultFolderForImportExport(String newDefaultLocation) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.put(DEFAULT_FOLDER_FOR_IMPORT_EXPORT, newDefaultLocation);
    }

    public String getDefaultFolderForSnapshot(String defaultLocation) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.get(DEFAULT_FOLDER_FOR_SNAPSHOT, defaultLocation);
    }

    public void setDefaultFolderForSnapshot(String newDefaultLocation) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.put(DEFAULT_FOLDER_FOR_SNAPSHOT, newDefaultLocation);
    }

    public String getDefaultFolderForSnapshotPDF(String defaultLocationPDF) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.get(DEFAULT_FOLDER_FOR_SNAPSHOT_PDF, defaultLocationPDF);
    }

    public void setDefaultFolderForSnapshotPDF(String newDefaultLocationPDF) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.put(DEFAULT_FOLDER_FOR_SNAPSHOT_PDF, newDefaultLocationPDF);
    }

    public String getColorResource(String colorResource, String defaultValue) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.get(colorResource, defaultValue);
    }

    public void setMaxNumDestinationNodes(int numDestinationNodes) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putInt(MAX_NUM_DESTINATION_NODES, numDestinationNodes);
    }

    public int getMaxNumDestinationNodes() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getInt(MAX_NUM_DESTINATION_NODES, 1);
    }

    public void setMaxNumSourceNodes(int numDestinationNodes) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putInt(MAX_NUM_SOURCE_NODES, numDestinationNodes);
    }

    public int getMaxNumSourceNodes() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getInt(MAX_NUM_SOURCE_NODES, 1);
    }

    public void setMaxValueForRandomWeight(int maxValueForRandomWeight) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putInt(MAX_VALUE_FOR_RANDOM_WEIGHT, maxValueForRandomWeight);
    }

    public int getMaxValueForRandomWeight() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getInt(MAX_VALUE_FOR_RANDOM_WEIGHT, 5);
    }

    public void setMinValueForRandomWeight(int minValueForRandomWeight) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putInt(MIN_VALUE_FOR_RANDOM_WEIGHT, minValueForRandomWeight);
    }

    public int getMinValueForRandomWeight() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getInt(MIN_VALUE_FOR_RANDOM_WEIGHT, 1);
    }

    public void setMaxValueForRandomEstimate(int maxValueForRandomEstimate) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putInt(MAX_VALUE_FOR_RANDOM_ESTIMATE, maxValueForRandomEstimate);
    }

    public int getMaxValueForRandomEstimate() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getInt(MAX_VALUE_FOR_RANDOM_ESTIMATE, 10);
    }

    public void setMinValueForRandomEstimate(int minValueForRandomEstimate) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putInt(MIN_VALUE_FOR_RANDOM_ESTIMATE, minValueForRandomEstimate);
    }

    public int getMinValueForRandomEstimate() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getInt(MIN_VALUE_FOR_RANDOM_ESTIMATE, 1);
    }

    public void setCompleteSnapshot(boolean isCompleteSnapshot) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putBoolean(COMPLETE_SNAPSHOT, isCompleteSnapshot);
    }

    public boolean getCompleteSnapshot() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getBoolean(COMPLETE_SNAPSHOT, false);
    }

    public void setSnapshotPDF(boolean isSnapshotPDF) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putBoolean(SNAPSHOT_PDF_ENABLE, isSnapshotPDF);
    }

    public boolean getSnapshotPDF() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getBoolean(SNAPSHOT_PDF_ENABLE, false);
    }

    public boolean isDuplicateNodeCheckingEnabled() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getBoolean(DUPLICATE_NODE_CHECKING_ENABLE, true);
    }

    public void setDuplicateNodeCheckingEnabled(boolean isDuplicateNodeCheckingEnabled) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putBoolean(DUPLICATE_NODE_CHECKING_ENABLE, isDuplicateNodeCheckingEnabled);
    }

    public void setFirstLaunch(boolean isFirstLaunch) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putBoolean(FIRST_LAUNCH, isFirstLaunch);
    }

    public boolean isFirstLaunch() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getBoolean(FIRST_LAUNCH, true);
    }

    public void setFringeOrderedByNodeLabelDesc(boolean isFringeOrderedByNodeLabelDesc) {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        this.preferences.putBoolean(FRINGE_ORDERED_BY_NODE_LABEL_DESC, isFringeOrderedByNodeLabelDesc);
    }

    public boolean isFringeOrderedByNodeLabelDesc() {
        this.preferences = Preferences.userRoot().node(this.getClass().getName());
        return this.preferences.getBoolean(FRINGE_ORDERED_BY_NODE_LABEL_DESC, true);
    }
}

